#!/bin/bash

if [ 2 != $# ] ; then
  echo 'usage: ' $(basename -s .sh $0) YYMMDD N
  exit 1
fi

set -eu

prog=/home/povray/yuqk_a5c25dda/bin/povray

ini=icls.ini

# codeDir=/home/jr/src/povray/icls
codeDir=/home/jr/wip/iclink
workDir=/tmp
doneDir=/tmp/icls

mkdir -p $doneDir

cd $codeDir

$prog $ini declare=Pdt=$1 declare=Psn=$2

cd $workDir

xz -9e alltext.out

mv alltext.out.xz ${doneDir}/cl-${1}-${2}.log.xz

convert icls_l.png -resize 600x800 ${doneDir}/cl-${1}-${2}.png

xv -rm 5 -root -quit ${doneDir}/cl-${1}-${2}.png

rm -f icls_l.png parse_fore.tmp

exit 0

