/* Chain Link puzzle solver */
// +w600 +h600 +a declare=Pdt=yymmdd declare=Psn=n

#version 3.8;

global_settings {assumed_gamma 1}

#include "filed.inc"
#include "foreach.inc"
#include "tmc.inc"
/* solver & supporting code */
#include "icls.inc"

/* the puzzle data file directory.  edit to suit.
 * NB the trailing directory/path separator is needed.
 */
#declare fild_workingDir = "/home/jr/var/games/clink/";

/* the puzzle's date and serial number can be supplied via the .ini
 * file; the solver script uses command-line 'declare's.
 */
#if (!defined(global.Pdt))
  #error "oops, expected a puzzle date ('Pdt') of format 'YYMMDD'."
#elseif (!iclsIsInt(Pdt))
  #error "oops, expected a puzzle date ('Pdt') of format 'YYMMDD'."
#end

#if (!defined(global.Psn))
  #error "oops, expected a puzzle serial number ('Psn'), eg '1' or '3'."
#elseif (!iclsIsInt(Psn))
  #error "oops, expected a puzzle serial number ('Psn'), eg '1' or '3'."
#end

/* override for a clues-only grid, to print and solve manually :-) */
#if (!defined(global.Solve))
  #declare iclsOptSolve = true;
#elseif (!iclsIsBool(Solve))
  #error "oops, expected a boolean 'Solve' value."
#else
  #declare iclsOptSolve = Solve;
#end

/* control textual "feedback" */
#if (!defined(global.Debug))
  #declare iclsOptDebug = false;
#elseif (!iclsIsBool(Debug))
  #error "oops, expect boolean value for 'Debug'."
#else
  #declare iclsOptDebug = Debug;
#end

#if (!defined(global.Verbose))
  #declare iclsOptVerbose = false;
#elseif (!iclsIsBool(Verbose))
  #error "oops, expect boolean value for 'Verbose'."
#else
  #declare iclsOptVerbose = Verbose;
#end

/* data file( name)s are expected to be in the specified format.
 * without any clues need 36 "records", check for 1 clue min.
 */
#declare file_ = dictionary {
  .File     : concat("cl-",str(Pdt,0,0),"-",str(Psn,0,0),".csv"),
  .Access   : "r",
  .Fields   : array [1] {"I"},
  .hasNames : true,
  .Verbose  : (iclsOptVerbose & iclsOptDebug)
};
Filed(file_)

#if (mod(dimension_size(file_.Data,1),2) | dimension_size(file_.Data,1) < 38)
  #error "oops, bad file data, bailing out."
#end

/* build the solver dictionary and keep an "image" */
#declare puzzle_ = iclsMakePuzzle(file_);

#declare as_input_ = iclsDrawGrid(puzzle_);

/* summary before */
#declare s_ = concat("\nChain Link puzzle '",puzzle_.legend_,"',");
#debug concat(s_," given ",str(puzzle_.ccnt_,0,0)," clues.\n\n")

iclsDumpPuzzle(puzzle_)

/* the solver can be bypassed, that is, just "print out" the puzzle
 * as given.  the "Sunday morning" option :-).
 */
#if (iclsOptSolve)

/* a "grand-total calls" counter */
#declare gttl_ = tmcNew();

#macro icls__xferCounts(i_,elem_,arg_)
  #if (defined(gttl_[elem_]))
    icls__incr(gttl_[elem_],arg_[elem_])
  #else
    #declare gttl_.k_[dimension_size(gttl_.k_,1)] = elem_;
    #declare gttl_[elem_] = arg_[elem_];
  #end
#end

icls__debugEmit("entering solver loop")

#declare new_ = -1;
#declare pass_ = 0;

#while (new_)

  #local new_ = 0;
  #declare tmcn_ = tmcNew();

  icls__incr(pass_,)
  #if (iclsOptDebug) icls__passSepEmit(pass_) #end

  /* strategy 1, "low-hanging fruit".  for every row, column, chain,
   * and grid cell, check if there's only one specific digit "legal",
   * given the current state.
   */
  icls__incr(new_,iclsSingletons(puzzle_))


  /* add further strategies as needed */
  icls__incr(new_,iclsStub(puzzle_))


  /* update the counters */
  #if (new_)
    Foreach(tmcn_.k_, dictionary {.Macro: "icls__xferCounts", .Arg: "tmcn_"})
    #if (iclsOptDebug) tmcReport(tmcn_) #end
  #end
  #undef tmcn_

#end

#if (iclsOptDebug)
  icls__debugEmit(concat("exiting solver, pass #",str(pass_,0,0)))
  #debug concat("[II] macro call counters:","\n")
  tmcReport(gttl_)
#end

#if (36 = puzzle_.ccnt_)
  #debug concat("puzzle '",puzzle_.legend_,"' solved.","\n\n")
#else
  #debug concat("puzzle '",puzzle_.legend_,"' not solved, ",
          str(36-puzzle_.ccnt_,0,0)," digits missing/not found.","\n\n")
  iclsDumpPuzzle(puzzle_)
#end

#end /* iclsOptSolve */

/* the "scene" */

background {icls__data_colours_[2]}

iclsDrawGrid(puzzle_)

text {
  ttf "timrom.ttf", concat("Chain Link puzzle '",puzzle_.legend_,"'."), .1, 0
  icls__objTexture(1)
  scale .35
  translate <0.35,-9.25,0>
}

camera {
  orthographic
  location <4.25, -4.50, -10>
  right x * (1/1)
  up y
  angle 55
  look_at <4.25, -4.50, 0>
}

