
//   pointData from spine_A.x3d
//   m.miller 8.8.2023//   note: lathe requires positive x for all points
//         prisms are plotted on z plane and extrude in y

//--- pointArray 
#declare pointDataCount = 7 ;
#declare pointArray = array mixed [pointDataCount][2] ;
#declare pointArray[0][0] = <61.580, 26.893, -0.000>  ;
#declare pointArray[0][1] = 2.308 ;
#declare pointArray[1][0] = <61.629, 31.953, -0.000>  ;
#declare pointArray[1][1] = 2.308 ;
#declare pointArray[2][0] = <61.938, 36.812, -0.000>  ;
#declare pointArray[2][1] = 2.308 ;
#declare pointArray[3][0] = <62.342, 40.199, -0.000>  ;
#declare pointArray[3][1] = 1.260 ;
#declare pointArray[4][0] = <63.813, 48.231, -0.000>  ;
#declare pointArray[4][1] = 0.956 ;
#declare pointArray[5][0] = <66.088, 56.402, -0.000>  ;
#declare pointArray[5][1] = 0.668 ;
#declare pointArray[6][0] = <66.914, 58.764, -0.000>  ;
#declare pointArray[6][1] = 0.478 ;

//--- prism Z
#declare spine_A_prism_z =
prism {
    linear_spline
    0, 1, 8,
    <61.580,-0.000>,
    <61.629,-0.000>,
    <61.938,-0.000>,
    <62.342,-0.000>,
    <63.813,-0.000>,
    <66.088,-0.000>,
    <66.914,-0.000>
    <61.580,-0.000>
}

//--- prism Y
#declare spine_A_prism_y =
prism {
    linear_spline
    0, 1, 8,
    <61.580,26.893>,
    <61.629,31.953>,
    <61.938,36.812>,
    <62.342,40.199>,
    <63.813,48.231>,
    <66.088,56.402>,
    <66.914,58.764>
    <61.580,26.893>
}

//--- lathe
#declare spine_A_lathe =
lathe{ 
      cubic_spline
      7,
      <61.580,26.893>, 
      <61.629,31.953>, 
      <61.938,36.812>, 
      <62.342,40.199>, 
      <63.813,48.231>, 
      <66.088,56.402>, 
      <66.914,58.764>
      }

//--- cubic spline sweep
#declare sf=1;
#declare spine_A_sweep_cubic =
sphere_sweep {
     cubic_spline
     9,
     <61.580, 26.893, -0.000> , 2.308*sf, 
     <61.580, 26.893, -0.000> , 2.308*sf, 
     <61.629, 31.953, -0.000> , 2.308*sf, 
     <61.938, 36.812, -0.000> , 2.308*sf, 
     <62.342, 40.199, -0.000> , 1.260*sf, 
     <63.813, 48.231, -0.000> , 0.956*sf, 
     <66.088, 56.402, -0.000> , 0.668*sf, 
     <66.914, 58.764, -0.000> , 0.478*sf, 
     <66.914, 58.764, -0.000> , 0.478*sf
     tolerance 0.000001
     }

//--- linear spline sweep
#declare sf=1;
#declare spine_A_sweep_linear =
sphere_sweep {
     linear_spline
     9,
     <61.580, 26.893, -0.000> , 2.308*sf, 
     <61.580, 26.893, -0.000> , 2.308*sf, 
     <61.629, 31.953, -0.000> , 2.308*sf, 
     <61.938, 36.812, -0.000> , 2.308*sf, 
     <62.342, 40.199, -0.000> , 1.260*sf, 
     <63.813, 48.231, -0.000> , 0.956*sf, 
     <66.088, 56.402, -0.000> , 0.668*sf, 
     <66.914, 58.764, -0.000> , 0.478*sf, 
     <66.914, 58.764, -0.000> , 0.478*sf
     tolerance 0.000001
     }

//--- plotted spheres
#declare spine_A_spheres =
union {
     sphere{<0,0,0>, 2.308 translate <61.580, 26.893, -0.000>  }
     sphere{<0,0,0>, 2.308 translate <61.629, 31.953, -0.000>  }
     sphere{<0,0,0>, 2.308 translate <61.938, 36.812, -0.000>  }
     sphere{<0,0,0>, 1.260 translate <62.342, 40.199, -0.000>  }
     sphere{<0,0,0>, 0.956 translate <63.813, 48.231, -0.000>  }
     sphere{<0,0,0>, 0.668 translate <66.088, 56.402, -0.000>  }
     sphere{<0,0,0>, 0.478 translate <66.914, 58.764, -0.000>  }
     }

//--- plotted cones
#declare spine_A_cones =
union {
     cone{<61.580, 26.893, -0.000> ,2.308,<61.629, 31.953, -0.000> ,2.308}
     cone{<61.629, 31.953, -0.000> ,2.308,<61.938, 36.812, -0.000> ,2.308}
     cone{<61.938, 36.812, -0.000> ,2.308,<62.342, 40.199, -0.000> ,1.260}
     cone{<62.342, 40.199, -0.000> ,1.260,<63.813, 48.231, -0.000> ,0.956}
     cone{<63.813, 48.231, -0.000> ,0.956,<66.088, 56.402, -0.000> ,0.668}
     cone{<66.088, 56.402, -0.000> ,0.668,<66.914, 58.764, -0.000> ,0.478}
     }
