// brain bot preview space
// m.miller 07.14.23

#version 3.8; 
global_settings {  
    max_trace_level 7
    ambient_light <.013,.01,.01> * 10
    assumed_gamma 1                
}                        

#declare lights_on = 0; 
#declare light_butt_on = 0; 


#include "pipes_tanks.inc" 
//object { process_unit rotate <0,0,0> translate <0,0,0> }

object { process_unit scale <1.8,1.8,1.8> rotate <0,0,0> translate <-400,-80,400> }
object { process_unit scale <2,2,2> rotate <0,90,0> translate <320,-270,600> }
object { process_unit_horz scale <2,2,2> rotate <90,0,0> rotate <0,90,0>translate <-330,-230,600> }
object { process_unit_horz scale <2,-2,2> rotate <90,0,0> rotate <0,90,0>translate <-330,-230,600> }

#include "brain_bot.inc"  
#include "bot_A_tenticles.inc" 
#include "bot_B_tenticles.inc" 

#declare bot_pose_A =
union {
    object { bot_A_leg_left }
    object { bot_A_leg_right }  
    object { bot_A_arm_left }
    object { bot_A_arm_right }
    object { brain_bot scale <2.3,2.3,2.3> rotate <0,0,-15> translate <78,403.0,38.25>}  
    translate <0,0,0>
} 

#declare bot_pose_B =
union {
    object { bot_B_leg_left }
    object { bot_B_leg_right }  
    object { bot_B_arm_left }
    object { bot_B_arm_right }  
    object { brain_bot scale <2.3,2.3,2.3> rotate <0,15,0> translate <139.5,203,52.35>} 
    translate <18,40,0>
}  

//object {bot_pose_A} 
//object {bot_pose_B}

// -----------------------------------------------------------------------------------------
//                     L I G H T S 
//------------------------------------------------------------------------------------------



// light
#declare light_process_unit =
light_source {
    <0,0,0> 
    #declare light_color = color red 1 green 1 blue 1 ;                      
    light_color * 1000                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    16, 16                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 4
    fade_power 2     
    translate <0,0,0>   
    shadowless
}  


object {light_process_unit translate <400,400,400>}
object {light_process_unit translate <100,-200,300>} 
object {light_process_unit translate <100,-200,700>}
object {light_process_unit translate <-300,100,200>}
object {light_process_unit translate <-300,500,200>}

// under light - no shadows
#declare light_under =
light_source {
    <0,0,0> 
    #declare light_color = color red .03 green .035 blue .03 ;                      
    light_color * 30                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <-200,-100, -300>   

}   
#if (lights_on) light_under #end
                           
                           
// top back light 
#declare light_top =
light_source {
    <0,0,0> 
    #declare light_color = color red .04 green .04 blue .04 ;                      
    light_color * 5                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 600
    fade_power 2     
    translate <200,800,-300>   
}   

#if (lights_on) light_top #end




// -----------------------------------------------------------------------------------------
//                      S K Y  D O M E
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * 1 } 
 
#macro bg_sphere (sc, pos, rot, img) 
object {
    sphere  
        { 0 1 
        hollow
        pigment{
            image_map{ 
                //hdr img
                //jpeg img   
                png img        
                map_type 1 
                interpolate 4 
                }
      }        
      finish { 
        ambient  1.0 
        diffuse  1 
        emission 2
        }
      scale sc  
      translate pos
      rotate <0, rot, 0>  
      } 
}  
#end

#declare img = "background_4k.png"
// bg_sphere (scale, position, rotation, image) 
//object { bg_sphere (<2000,2000,2000>, <0,10,0>, 320, img) scale <-1,1,1> }






// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------ 
#declare cam_front =
    camera {
        up <0, 1, 0>  
        angle .5    
        location <50,200,-50000> 
        look_at <140,200,0>
    } 

#declare cam_top =
    camera {
        up <0, 1, 0>  
        angle .5    
        location <140,50000,-.5> 
        look_at <140,0,0>
    } 
    
#declare cam_side =
    camera {
        up <0, 1, 0>  
        angle 10    
        location <-1000,200,0> 
        look_at <0,50,0>
    } 

#declare cam_A =
    camera {
        up <0, 1, 0>  
        angle 50    
        location <200,-40,-50> 
        look_at <0,-40,-50>
    } 
    
#declare cam_B =
    camera {
        up <0, 1, 0>  
        angle 30    
        location <-60,120,-550> 
        look_at <-50,100,0>
    } 


#declare cam_C =
    camera {
        up <0, 1, 0>  
        angle 65    
        location <-100,-30,-270> 
        look_at <-40,130,0>
    } 

#declare cam_D =
    camera {
        up <0, 1, 0>  
        angle 45    
        location <0,700,-480> 
        look_at <0,315,0>
    } 
    
    
#declare cam_E =
    camera {
        up <0, 1, 0>  
        angle 80    
        location <144,350,-520> 
        look_at <60,280,0>
    } 
//camera {cam_front}    //hide sky & stage
//camera {cam_side}     //hide sky & stage
//camera {cam_elev}     //hide sky & stage
camera {cam_E}    
