// brain bot preview space
// m.miller 07.14.23

#version 3.8; 
global_settings {  
    max_trace_level 7
    ambient_light <.013,.01,.01> * 1 
    assumed_gamma 1                
}                        


#declare lights_on = true;

// -----------------------------------------------------------------------------------------
//                    B R A I N    B O T
//------------------------------------------------------------------------------------------ 
#include "brain_bot.inc"  
object { brain_bot rotate <30,0,0> translate <-30,0,0>}
object { brain_bot rotate <15,-40,0> translate <40,10,-20>}




#declare w = 10;
#declare h = 10;
#declare d = 10;
#declare web_width = 2;
#declare flange_height = 2;
#declare void_width = (w-web_width);
#declare void_height = (w-web_width);



#macro i_beam()





#end
















// -----------------------------------------------------------------------------------------
//                     L I G H T S 
//------------------------------------------------------------------------------------------



// under light - no shadows
#declare light_under =
light_source {
    <0,0,0> 
    #declare light_color = color red .015 green .02 blue .01 ;                      
    light_color * 50                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <0,-200, -20>   
    shadowless
}   
#if (lights_on) light_under #end
                           
                           
// top back light 
#declare light_top =
light_source {
    <0,0,0> 
    #declare light_color = color red .025 green .02 blue .03 ;                      
    light_color * 35                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <200,200,250>   
}   

#if (lights_on) light_top #end

         
 #declare light_brain =
light_source {
    <0,0,0> 
    #declare light_color = color red .04 green .02 blue .01 ;                      
    light_color * 200                  
    area_light
    <20, 0, 0> <0, 0, 20>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 20
    fade_power 2     
    translate <-30,0,-10>   
    shadowless
}   
#if (lights_on) light_brain #end







#declare light_weapon_top =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .03 blue .05 ;                      
    light_color * 200                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 5
    fade_power 2     
    translate <-70, 30, -40>   
    //shadowless
}   
#if (lights_on) light_weapon_top #end


// -----------------------------------------------------------------------------------------
//                      S K Y  D O M E
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * 1 } 
 
#macro bg_sphere (sc, pos, rot, img) 
object {
    sphere  
        { 0 1 
        hollow
        pigment{
            image_map{ 
                //hdr img
                jpeg img          
                map_type 1 
                interpolate 4 
                }
      }        
      finish { 
        ambient  1.0 
        diffuse  1 
        emission 2
        }
      scale sc  
      translate pos
      rotate <0, rot, 0>  
      } 
}  
#end

#declare img = "background_4k.jpg"
// bg_sphere (scale, position, rotation, image) 
object { bg_sphere (<2000,2000,2000>, <0,10,0>, 320, img) scale <-1,1,1> }






// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------ 
#declare cam_front =
    camera {
        up <0, 1, 0>  
        angle 10    
        location <0,-50,-500> 
        look_at <0,-5,0>
    } 

#declare cam_top =
    camera {
        up <0, 1, 0>  
        angle 30    
        location <-15,250,-30> 
        look_at <-15,0,-30>
    } 
    
#declare cam_side =
    camera {
        up <0, 1, 0>  
        angle 10    
        location <-1000,200,0> 
        look_at <0,50,0>
    } 

#declare cam_A =
    camera {
        up <0, 1, 0>  
        angle 50    
        location <200,-40,-50> 
        look_at <0,-40,-50>
    } 
    
#declare cam_B =
    camera {
        up <0, 1, 0>  
        angle 45    
        location <-30,100,-270> 
        look_at <20,-20,0>
    } 


#declare cam_C =
    camera {
        up <0, 1, 0>  
        angle 60    
        location <5,30,-140> 
        look_at <-5,15,0>
    } 
      
//camera {cam_front}    //hide sky & stage
//camera {cam_side}     //hide sky & stage
//camera {cam_elev}     //hide sky & stage
camera {cam_B}