// gearbox materials


// -----------------------------------------------------------------------------------------
//                      C O L O R S
//------------------------------------------------------------------------------------------ 
#declare C_clear  =         rgbt 1 ;
#declare C_black =          color rgb   <0,     0,      0>    ;
#declare C_gray50 =         color rgb   <0.5,   0.5,    0.5>  ;
#declare C_gray60 =         color rgb   <0.6,   0.6,    0.6>  ; 
#declare C_gray70 =         color rgb   <0.7,   0.7,    0.7>  ;   
#declare C_gray80 =         color rgb   <0.8,   0.8,    0.8>  ; 
#declare C_brass =          color rgb   <0.62,  0.33,   0.1>  ;
#declare C_rust_red =       color rgb   <0.6,   0.3,    0.25> ;
#declare C_rust_gray =      color rgb   <0.80,  0.80,   0.85> ;
#declare C_rust_gray_dark = color rgb   <0.70,  0.70,   0.80> ;
#declare C_brass_film =     color rgbt  <0.62,  0.33,   0.1,    .8> ;
#declare C_rust_red_film =  color rgbt  <0.5,   0.3,    0.25,   .5> ;
#declare C_rust_gray_film = color rgbt  <0.5,   0.5,    0.5,    .5> ; 
#declare C_rust_tan_film =  color rgbt  <0.75,  0.6,    0.5,    .75>; 


// -----------------------------------------------------------------------------------------
//                      C O L O R   M A P S 
//------------------------------------------------------------------------------------------ 
#declare C_map_brass = 
color_map {
    [0.0        C_brass *1.5]
    [0.2        C_brass *1.5]
    [0.25       C_brass *1.3] 
    [0.35       C_brass *1.5]
    [0.45       C_brass *1.3]
    [0.9        C_brass *1.5]
    [1.000      C_brass *1.2]
}

#declare C_map_rust_red = 
color_map {
    [0.0        C_rust_gray ]
    [0.2        C_rust_red * .5]
    [0.25       C_rust_red * .7] 
    [0.4        C_rust_gray * 1]
    [0.85       C_rust_gray * 1.5]
    [0.9        C_rust_red * .6]
    [1.000      C_rust_gray]
}


#declare C_map_rust_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_rust_red_film ]
    [0.25       C_rust_red_film * 1.5] 
    [0.35       C_rust_gray_film]
    [0.45       C_clear]
    [0.9        C_clear]
    [1.000      C_clear]
}


#declare C_map_brass_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_brass_film ]
    [0.25       C_brass_film * 1.5] 
    [0.35       C_brass_film]
    [0.45       C_clear]
    [0.9        C_clear]
    [1.000      C_clear]
}

#declare C_map_rust_normal = 
color_map {
    [0.0        C_white ]
    [0.2        C_gray50 ]
    [0.25       C_black ] 
    [0.35       C_gray50 ]
    [0.45       C_gray80 ]
    [0.9        C_white ]
    [1.000      C_white ]
}

// -----------------------------------------------------------------------------------------
//                      F I N I S H E S 
//------------------------------------------------------------------------------------------ 

#declare F_matt =
finish {
    ambient 1
    diffuse 0   
    phong 0
    phong_size 0  
    emission 0
} 

#declare F_metal_soft  =
finish {
    reflection {0, .5 fresnel on }
    conserve_energy 
    brilliance 5
    ambient .1
    diffuse 1 
    phong 5    
    phong_size 20
    metallic
    specular .4
    roughness 1/20
    reflection .10    
}

#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}

// -----------------------------------------------------------------------------------------
//                      T E X T U R E S
//------------------------------------------------------------------------------------------ 

//--- chrome
#declare T_metal_chrome = 
texture{ 
    pigment{ color red 0.8 green 0.8 blue 0.8 }   
    finish{ F_metal_polished }
}


//--- brass old 
#declare sz = <1,1,1>*.5 ;   
#declare turb = 1.1; 
#declare bump = .1; 
#declare T_brass_old =
texture { 
    pigment { 
    spotted 
    color_map {C_map_brass} 
    turbulence turb
    scale sz
    } 
    finish{F_metal_soft}
}


//--- stained overlay map for gearbox
#declare imgDiffuse = "gear_box_diffuse.png" 
#declare T_gear_box =
texture {
   pigment { 
        image_map {
            png imgDiffuse     
            map_type 0
            interpolate 4 
            }
  }

    finish { 
        F_matt
    }
    scale <28,42,1> 
    rotate <90,0,0> 
    translate <-14,0,-21>
}


//--- spotted reddish dents matt finish
#declare sz = <1,1,1>*.5 ;   
#declare turb = .5; 
#declare bump = .1; 

#declare T_rust_spots =
texture { 
    pigment { 
        spotted 
        color_map {C_map_rust_overlay} 
        turbulence turb
        scale sz
        } 

    finish{F_matt}
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {C_map_rust_normal} 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }
 



// -----------------------------------------------------------------------------------------
//                     M A T E R I A L S
//------------------------------------------------------------------------------------------ 

#declare M_brass_old_stained =
material {
    texture { T_brass_old scale <.5,.5,.5> }
    texture { T_gear_box }
}

#declare M_brass_old =
material {
    texture { T_brass_old scale <.5,.5,.5> }
    texture { T_gear_box }
}



#declare M_chrome_old =
material { 
   texture { T_metal_chrome scale <1,1,1>}
   texture { T_rust_spots   scale <.1,.1,.1>}
}

