// object review
// m.miller 04.22.23

#version 3.8; 
global_settings {    
    max_trace_level 7
    ambient_light <.013,.01,.01> * 10 
    assumed_gamma 1                
}                        


// -----------------------------------------------------------------------------------------
//                     L I G H T S 
//------------------------------------------------------------------------------------------
#declare light_left =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 5                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <-200,200,-50>
}   
light_left

#declare light_right =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 15                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <200,200,-200>
}   
light_right

 


    
// -----------------------------------------------------------------------------------------
//                      S K Y
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * 1 } 
#declare img = "room_2k.jpg"

#macro bg_sphere (sc, pos, rot) 
object {
    sphere  
        { 0 1 
        hollow
        pigment{
            image_map{ 
                //hdr img
                jpeg img          
                map_type 1 
                interpolate 4 
                }
      }        
      finish { 
        ambient  1.0 
        diffuse  1 
        emission 1
        }
      scale sc  
      translate pos
      rotate <0, rot, 0>  
      } 
}  
#end

object { bg_sphere (<2000,2000,2000>, <0,10,0>, 250) scale <-1,1,1> }



       
// -----------------------------------------------------------------------------------------
//                      S T A G E 
//------------------------------------------------------------------------------------------  
#include "stage.inc"  
stage





// -----------------------------------------------------------------------------------------
//                    C O R K S C R E W S
//------------------------------------------------------------------------------------------ 
#include "corkscrew.inc"

object { corkscrew(0) rotate <0,5,0> translate <0,0,0> }
object { corkscrew(0) rotate <98.25,0,0> rotate <0,120,0> translate <20,11,45> }
object { corkscrew(40) rotate <0,-30,0> rotate <48,0,0> translate <-50,20,20> }



// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------ 
#declare cam_front =
    camera {
        up <0, 1, 0>  
        angle 1    
        location <100,40,-10000> 
        look_at <0,40,0>
    } 

#declare cam_elev =
    camera {
        up <0, 1, 0>  
        angle 1    
        location <0,30,-10000> 
        look_at <0,40,0>
    } 
    
#declare cam_side =
    camera {
        up <0, 1, 0>  
        angle 10    
        location <-1000,200,> 
        look_at <0,50,0>
    } 

#declare cam_A =
    camera {
        up <0, 1, 0>  
        angle 38    
        location <5,45,-230> 
        look_at <5,36,0>
    } 
    

//camera {cam_front}    //hide sky & stage
//camera {cam_side}     //hide sky & stage
//camera {cam_elev}     //hide sky & stage
camera {cam_A}