// receptical
// m.miller 04.14.23

// -----------------------------------------------------------------------------------------
//                       M A T E R I A L S
//------------------------------------------------------------------------------------------
#declare C_tan =                color red 0.85 green 0.66 blue 0.5;
#declare C_rust =               color rgb <0.80, 0.80, 0.85> ;
#declare C_rust_dark =          color rgb <0.70, 0.70, 0.80>  ;


#declare F_plastic =
finish {
    ambient .2
    diffuse 1   
    phong .7
    phong_size 80  
    //reflection {.05, .7 fresnel}
}

#declare F_rubber =
finish {
    ambient .2
    diffuse 1   
    phong .5
    phong_size 20  
}

#declare M_plastic_tan =
material {
    texture {
       pigment { C_tan }
       finish  { F_plastic }
   }
}

#declare M_plastic_black =
material {
    texture {
       pigment { C_black }
       finish  { F_plastic }
   }
}
  
  
#declare M_black_rubber =
material {
    texture {
       pigment { C_black }
       finish { F_rubber }
   }
}
  

#declare C_map_rust = 
    color_map {
        [0.0        C_rust]
        [0.1        C_rust_dark]
        [0.3        C_rust_dark * .9] 
        [0.55       C_rust * 1.5]
        [0.85       C_rust * 1.5]
        [0.9        C_rust_dark]
        [1.000      C_rust]
    }
    


#declare sz = .1;   
#declare turb = 1.1; 
#declare bump = .1;  //over the top

#declare M_pipe =
material {
    texture { 
        pigment { 
            spotted 
            color_map {C_map_rust} 
            turbulence turb
            scale sz
            } 
    
        finish{  
            ambient .2
            diffuse .85
            phong .5
            phong_size 25 
            //reflection {.005, .11 fresnel}
            }
        normal {
             crackle 
             turbulence turb 
             bump_size bump
             scale sz*.2
         }   
     }
     scale <20,20,20>
}

#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}
#declare M_metal_chrome = material{ texture{ pigment{color rgb<.8,.8,.8>} finish{F_metal_polished}}  }




// -----------------------------------------------------------------------------------------
//                       P A R T S
//------------------------------------------------------------------------------------------


#declare cover =
#declare rad = .5 ;
difference { 
    #declare sc = <6.000, 0.500, 10.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <4,2,4> translate <-0.000, 0.000, 0.000> } 
    
    #declare rad = 1 ;
    #declare sc = <9.235, 2, 17.162> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 2.5, 0.000> } 

    }




#declare void_A =  
difference {
    union { 
         cylinder { <0,-3,0>, <0,3,0>, 5.846 translate <-0.000, 0.000, 6.787> }
         cylinder { <0,-3,0>, <0,3,0>, 5.846 translate <-0.000, 0.000, -6.787> }
         }
    union { 
        #declare sc = <12.000, 10, 1.879> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, 0.000> } 
        #declare sc = <12.000, 10, 1.879> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, 13.735> } 
        #declare sc = <12.000, 10, 1.879> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, -13.613> } 
        
        
          } 
     
} 
     

#declare void_B =
#declare rad = .2 ;
union { 
    #declare sc = <0.820, 0.500, 2> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-2.400, 0.000, 7.964> } 
    #declare sc = <0.820, 0.500, 2> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <2.400, 0.000, 7.964> } 
    #declare sc = <0.820, 0.500, 2> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <2.400, 0.000, -5.721> } 
    #declare sc = <0.820, 0.500, 2> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-2.400, 0.000, -5.721> } 
    #declare sc = <1.000, 1, 0.600> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, 3.477> } 
    #declare sc = <1.000, 1, 0.600> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, -10.321> } 
      }


#declare void_C =
#declare rad = .05 ;
union { 
    #declare sc = <0.360, 2.190, 1.488> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-2.400, 0.000, -5.721> } 
    #declare sc = <0.360, 2.190, 1.488> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <2.400, 0.000, -5.721> } 
    #declare sc = <0.360, 2.190, 1.488> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <2.400, 0.000, 7.964> } 
    #declare sc = <0.360, 2.190, 1.488> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-2.400, 0.000, 7.964> } 
    #declare sc = <0.581, 2.190, 0.898> ;
    
    object {cylinder { <0,-1,0> , <0,5,0> 1.01 }  translate <-0.000, 0.000, -9.7> }
    object {cylinder { <0,-1,0> , <0,5,0> 1.01 }  translate <-0.000, 0.000, 4.1> }
    }


#declare female =  
difference {
    union { 
         cylinder { <0,0,0>, <0,.5,0>, 5.30 translate <-0.000, 0.000, 6.787> }
         cylinder { <0,0,0>, <0,.5,0>, 5.30 translate <-0.000, 0.000, -6.787> }
         }
    union { 
        #declare sc = <12.000, 10, 1.9> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2.51> translate <-0.000, 0.000, 0.000> } 
        #declare sc = <12.000, 10, 1.9> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2.51> translate <-0.000, 0.000, 13.735> } 
        #declare sc = <12.000, 10, 1.9> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2.51> translate <-0.000, 0.000, -13.613> } 
          } 
} 


#declare plug_end =
union {
   object { Round_Box(<-6,-6,0>, <6,6,10>,3,0) scale <.9,.7,1> } 
   object { Round_Cylinder(<0,0,0>, <0,0,5>, 3,1, 0)  scale <.9,.7,1> translate <0,0,-3> }
   material{M_black_rubber } 
}
 

#declare cord_part =
sphere_sweep { 
#declare sz = 1.3;
     cubic_spline
     19,
     <-0.000, 0.000, 0.000> , sz
     <-0.000, 0.000, 0.000> , sz
     <0.058, 0.000, -4.739> , sz
     <-0.234, -3.135, -10.045> , sz
     <-0.053, -8.634, -11.150> , sz
     <0.966, -14.974, -10.253> , sz
     <1.728, -22.028, -11.518> , sz
     <1.486, -28.317, -13.192> , sz
     <0.426, -36.658, -13.160> , sz
     <2.155, -45.952, -12.246> , sz
     <9.913, -56.797, -15.360> , sz
     <22.284, -58.977, -23.453> , sz
     <41.364, -58.394, -35.587> , sz
     <70.718, -52.254, -42.867> , sz
     <102.170, -55.312, -52.040> , sz
     <137.814, -59.534, -60.340> , sz
     <171.362, -57.653, -73.736> , sz
     <226.330, -56.790, -73.736> , sz
     <226.330, -56.790, -73.736> , sz 
     tolerance 0.000001              
     material {M_black_rubber}
     }
     
#declare cord = 
union{
    object {cord_part scale <1,1.03,1> translate <-.75,0,0>} 
    object {cord_part scale <1,1.02,.998> translate <.75,0,0>} 
}

#declare female2 =  
difference {
    union { 
         sphere { <0,0,0>, 5.70 scale <1,.23,1> translate <-0.000, 0.100, 6.787> }
         sphere { <0,0,0>, 5.70 scale <1,.23,1> translate <-0.000, 0.100, -6.787> }
         }
    union { 
        #declare sc = <12.000, 10, 1.9> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2.51> translate <-0.000, 0.000, 0.000> } 
        #declare sc = <12.000, 10, 1.9> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2.51> translate <-0.000, 0.000, 13.735> } 
        #declare sc = <12.000, 10, 1.9> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2.51> translate <-0.000, 0.000, -13.613> } 
        
         plane { <0,-1,0>, 0 translate <0,.85,0> }
        } 
     
} 


#declare screw_head = 
difference {
    sphere{ <0,0,0>, 1 scale <2.000, 2.000, 2.000> translate <-0.000, 0.000, 0.000> }
    #declare rad = .125 ; 
    #declare sc = <10.000, 2.000, 0.500> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 2.8, 0.000> } 
    scale <1.2,.75,1.2> 
    material {M_old_wall_light_tan}
}


#declare receptical_box =
#declare rad = 1.5 ;
difference { 
    #declare sc = <11.000, 8.000, 19.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, -8.000, 0.000> } 

    #declare sc = <11.000, 8.000, 19.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <1.9,1.9,1.9> translate <-0.000, -7.000, 0.000> } 
    material {M_pipe} 
    }

      
#declare pipe_with_flange = 
#declare fh = 15; 
union {        
    cylinder { <0,0,0>, <0,500,0>, 5 }                      // long pipe
    cylinder { <0,0,0>, <0,fh,0>, 5.75 }                    // collar
    torus { 5.4, 1  scale <1,.65,1> translate <0,fh,0>      }
    cylinder { <0,0,0>, <0,fh,0>, 1 translate <0,0,-5.2>    }
    cylinder { <0,0,0>, <0,fh,0>, 1 translate <-5.2,0,0>    }
    cylinder { <0,0,0>, <0,fh,0>, 1 translate <5.2,0,0>     }
    cylinder { <0,0,0>, <0,0,-9>, 2.5 translate <0,fh/2,0>  } 
    object {screw_head scale <.8,.8,.8> rotate <-90,0,0> translate <0,fh/2,-9.2> material {M_pipe} }
    material {M_pipe}
}
     
#declare receptical = 
union {
    union {
        object { screw_head scale <.5,.5,.5> rotate <0,30,0> translate <0,.15,0>}
        object { receptical_box }                                                 
        
        difference {
            union{
                object { female }
                object { female2 }  
            }
            object { void_B scale <1,3,1> translate <0,2.2,0>} 
            object { void_C scale <1,3,1> translate <0,0,0> material {M_plastic_black}}
        }
        difference { 
            object { cover }  
            object { void_A }
            sphere{ <0,0,0>, 1 scale <1.619, 1, 1.619> translate <-0.000, 1, 0> } 
        }
        material {M_old_wall_light_tan scale <.5,.5,.5>}
        rotate <-90,0,0> 
    }
    object { pipe_with_flange translate <0,18,10>} 
    
    object { plug_end translate <0,-7,-10>}  
    object { cord translate <0,-7,-10>} 
    
    
}


