// macro for simple coil shape using a pre-plotted circle 
// 24 points normalized from -1 to 1 
// m.miller 04.12.23
 

#macro coil (radA,radB,turns,h,objType)
                                  
    #declare sPoint = sphere {<0,0,0>, radB }                              
                           
    #declare pointDataCount = 24 ;
    #declare pointArray = array[pointDataCount] ;
    #declare pointArray[0] = <0.000, 0.000, 1.000>  ;
    #declare pointArray[1] = <-0.258, 0.000, 0.965>  ;
    #declare pointArray[2] = <-0.500, 0.000, 0.866>  ;
    #declare pointArray[3] = <-0.707, 0.000, 0.707>  ;
    #declare pointArray[4] = <-0.866, 0.000, 0.500>  ;
    #declare pointArray[5] = <-0.965, 0.000, 0.258>  ;
    #declare pointArray[6] = <-1.000, 0.000, 0.000>  ;
    #declare pointArray[7] = <-0.965, 0.000, -0.258>  ;
    #declare pointArray[8] = <-0.866, 0.000, -0.500>  ;
    #declare pointArray[9] = <-0.707, 0.000, -0.707>  ;
    #declare pointArray[10] = <-0.500, 0.000, -0.866>  ;
    #declare pointArray[11] = <-0.258, 0.000, -0.965>  ;
    #declare pointArray[12] = <0.000, 0.000, -1.000>  ;
    #declare pointArray[13] = <0.258, 0.000, -0.965>  ;
    #declare pointArray[14] = <0.500, 0.000, -0.866>  ;
    #declare pointArray[15] = <0.707, 0.000, -0.707>  ;
    #declare pointArray[16] = <0.866, 0.000, -0.500>  ;
    #declare pointArray[17] = <0.965, 0.000, -0.258>  ;
    #declare pointArray[18] = <0.999, 0.000, 0.000>  ;
    #declare pointArray[19] = <0.965, 0.000, 0.258>  ;
    #declare pointArray[20] = <0.866, 0.000, 0.500>  ;
    #declare pointArray[21] = <0.707, 0.000, 0.707>  ;
    #declare pointArray[22] = <0.500, 0.000, 0.866>  ;
    #declare pointArray[23] = <0.258, 0.000, 0.965>  ; 
    
   
    #if (objType="plotCoil")
        #declare c=pointDataCount;
        #declare yOffset = h/(pointDataCount*turns);
        #declare cnt=0;
        sphere_sweep {
        cubic_spline
        c * turns,
        #declare j=0; 
        #while (j<turns)
            #declare i=0;
            #while (i<c) 
                #declare cnt=cnt+1;
                #declare pos = pointArray[i];
                #declare nY = (cnt*yOffset);
                #declare nPos = <pos.x,pos.y + nY,pos.z>;
                nPos * radA , radB
                #declare i=i+1;
            #end 
            #declare j=j+1;
        #end
        tolerance 0.000001
        }
    #end 
    
    #if (objType="plotPoints")
        #declare c=pointDataCount;
        #declare yOffset = h/(pointDataCount*turns);
        #declare cnt=0;
        #declare j=0; 
        #while (j<turns)
            #declare i=0;
            #while (i<c) 
                #declare cnt=cnt+1;
                #declare pos = pointArray[i];
                #declare nY = (cnt*yOffset);
                #declare nPos = <pos.x,pos.y + nY,pos.z>;
                object { sPoint translate nPos * radA }
                #declare i=i+1;
            #end 
            #declare j=j+1;
        #end
    #end 
    
    
    
    
#end



