// -----------------------------------------------------------------------------------------
//                      W O O D   T O P
//------------------------------------------------------------------------------------------

#declare F_wood_shine =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 60  
    reflection {.001, .2 fresnel}
}

#declare F_gloss =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 100  
    reflection {.01, .72 fresnel on}
    metallic  
    roughness 1/100  
    brilliance 5
}

#declare imgDiffuse = "wood_top_diffuse.jpg" 
#declare imgBump = "wood_top_bump.jpg"

#declare M_wood_top =
material {
    texture {
       pigment { 
            image_map {
                jpeg imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
              
              
     finish { 
        //F_wood_shine 
        F_gloss
     }
     
    normal  {
        bump_map {
            jpeg imgBump 
            map_type 0
            interpolate 4 
        } 
        bump_size 1
    }
        
    }
    
    
    scale <200,200,200> 
    rotate x*90
    translate <-100,0,-100>  
}



#declare bench_top_slats =
#declare rad = .25 ;
union { 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -103.579> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -83.607> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -123.534> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -63.655> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -43.702> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -143.631> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -163.584> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -183.556> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -203.510> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -23.709> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -283.325> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -263.371> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -243.399> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -223.446> } 
    #declare sc = <347.001, 1.000, 2.921> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -296.309> } 
    #declare sc = <347.001, 1.000, 9.886> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 299.004, -3.696> } 
      }

    



#declare bench_top =
#declare rad = 2 ;
union { 
    #declare sc = <350.000, 8.000, 150.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 291.000, -150.000> } 
      }

#declare bench_trim =
#declare rad = 1 ;
union { 
    #declare sc = <4.000, 17.259, 144.969> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-336.004, 266.651, -137.210> } 
    #declare sc = <4.000, 17.259, 144.969> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <336.004, 266.651, -137.210> } 
    #declare sc = <340.000, 17.259, 4.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 266.651, -285.901> } 
      } 
      
#declare bench_legs =
#declare rad = 2 ;
union { 
    #declare sc = <16.000, 132.419, 16.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-315.103, 132.466, -265.310> } 
    #declare sc = <16.000, 132.419, 16.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <182.568, 132.466, -265.310> } 
    #declare sc = <16.000, 132.419, 16.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <315.642, 132.466, -265.310> } 
    #declare sc = <16.000, 132.419, 16.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <315.642, 132.466, -169.294> } 
    #declare sc = <16.000, 132.419, 16.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <182.568, 132.466, -169.294> } 
    #declare sc = <16.000, 132.419, 16.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-315.103, 132.466, -19.629> } 
      }


#declare bench_cabinet =
#declare rad = .25 ;
union { 
    #declare sc = <79.379, 99.669, 60.675> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <249.961, 165.336, -215.068> } 
    #declare sc = <46.235, 25.624, 2.936> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <249.961, 215.226, -278.754> } 
    #declare sc = <46.235, 25.624, 2.936> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <249.961, 157.578, -278.754> } 
    #declare sc = <46.235, 25.624, 2.936> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <249.961, 100.837, -278.754> } 
      }



#declare trim_A =
#declare rad = 1.25 ;
union { 
    #declare sc = <350.000, 24.610, 5.358> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 323.609, -5.091> } 

    #declare sc = <350.000, 9.129, 9.211> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, 2 , 0) scale <2,2,2> translate <-0.000, 301.851, -12.776> } 
    }






#declare wall_unit =
#declare rad = .5 ;
union { 
    union {
        #declare sc = <350.000, 6.009, 6.305> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 354.366, -9.384> } 
        #declare sc = <350.000, 6.009, 6.305> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 619.213, -9.384> } 
        #declare sc = <93.939, 2.616, 41.714> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <240.445, 564.880, -18.588> } 
        #declare sc = <94.742, 7.626, 2.947> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <240.445, 559.983, -62.904> } 
        #declare sc = <94.742, 7.626, 2.947> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <240.445, 471.918, -62.904> } 
        #declare sc = <93.939, 2.616, 41.714> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <240.445, 476.815, -18.588> } 
        #declare sc = <6.000, 126.622, 6.305> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-343.953, 486.961, -9.384> } 
        #declare sc = <6.000, 126.622, 6.305> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <344.087, 486.961, -9.384> } 
        #declare sc = <6.000, 126.622, 6.305> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <135.648, 486.961, -9.384> } 
        #declare sc = <6.000, 126.622, 6.305> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <147.923, 486.961, -9.384> } 
        material {M_old_wall_light_tan}

        }
        
        difference {
            #declare sc = <350.000, 136.370, .7> ;
            object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 487.181, -9.384> } 
            
            #declare hole=1.5;
            #declare punch = cylinder { <0,0,15>,<0,0,-15>, hole } ;
        
        
            #declare c=0; 
            #declare r=0;
            #declare rows=27;
            #declare cols=50;
            #declare c=0;
            #declare sX=-325;
            #declare sY=370;                 
            #declare gap=9;
            
            
            
            #while (r<rows)
                #declare c=0;
                #declare nY = (r*gap)+sY; 
                #while (c<cols)
                    #declare nX = (c*gap)+sX;
                    object { punch translate <nX,nY,0> }
                    #declare c=c+1;                 
                #end                 
                #declare r=r+1;             
            #end
        }
        
}


                 
#declare bench = 
union {
     object { bench_top_slats material {M_wood_top} }  
     object { bench_legs material {M_old_trim_tan rotate <90,0,0> rotate <0,0,0> translate <0,0,0>} }
     object { bench_top material {M_wood_top rotate <90,0,0>} }
     object { bench_trim material {M_old_trim_tan rotate <90,0,0> rotate <0,0,90>translate <0,4,0>} }   
     object { bench_cabinet material {M_old_trim_tan rotate <90,0,0> rotate <0,0,90>translate <0,4,0>} }
     object { trim_A material {M_old_trim } } 
     object { wall_unit material {M_old_wall_light_tan} translate <0,0,0> }
}  
    
    
    
    