// convert x3d
// m.miller 03.09.2023

#include "Shapes3.inc"





#declare pc_board_base =
#declare rad = .125 ;  
difference {
    union { 
        #declare sc = <28.000, 0.250, 32.000> ;
        object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.000, 0.250 - 0.250,32.000> } 
        #declare sc = <25.000, 0.174, 3.000> ;
        object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.000, 0.250 - 0.174,66.7> } 
        } 

        cylinder { <0,-2,0>,<0,2.00,0>, .5 scale <1,1,1> translate<-25,0,2.5> }  
        cylinder { <0,-2,0>,<0,2.00,0>, .5 scale <1,1,1> translate<25,0,2.5> } 
        cylinder { <0,-2,0>,<0,2.00,0>, .5 scale <1,1,1> translate<-25,0,62.5> }  
        cylinder { <0,-2,0>,<0,2.00,0>, .5 scale <1,1,1> translate<25,0,62.5> } 
}   


#declare pc_chips = 
#declare rad = .125 ;
union { 
    #declare sc = <6.475, 0.456, 6.475> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.917, 1.007 - 0.456,21.951> } 
    #declare sc = <6.475, 0.456, 6.475> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.917, 1.923 - 0.456,21.951> } 
    #declare sc = <3.383, 0.300, 3.383> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-11.527, 1.482 - 0.300,42.286> } 
    #declare sc = <3.383, 0.300, 3.383> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-11.527, 0.880 - 0.300,42.286> } 
    #declare sc = <3.383, 0.300, 3.383> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-11.527, 0.880 - 0.300,54.381> } 
    #declare sc = <3.383, 0.300, 3.383> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-11.527, 1.482 - 0.300,54.381> } 
    #declare sc = <1.326, 0.300, 4.331> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <16.956, 1.482 - 0.300,54.707> } 
    #declare sc = <1.326, 0.300, 4.331> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <16.956, 0.880 - 0.300,54.707> } 
    #declare sc = <1.326, 0.300, 4.370> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <16.956, 0.880 - 0.300,42.065> } 
    #declare sc = <1.326, 0.300, 4.370> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <16.956, 1.482 - 0.300,42.065> } 
    #declare sc = <1.326, 0.300, 4.378> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <16.956, 1.482 - 0.300,14.836> } 
    #declare sc = <1.326, 0.300, 4.378> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <16.956, 0.880 - 0.300,14.836> } 
    #declare sc = <1.326, 0.300, 4.321> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <16.974, 0.880 - 0.300,27.767> } 
    #declare sc = <1.326, 0.300, 4.321> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <16.974, 1.482 - 0.300,27.767> } 
    #declare sc = <9.586, 1.015, 1.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <10.114, 2.229 - 1.015,4.012> } 
    #declare sc = <9.410, 0.330, 0.852> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <10.114, 0.891 - 0.330,4.012> } 
    #declare sc = <9.410, 0.330, 0.852> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-10.061, 0.891 - 0.330,4.012> } 
    #declare sc = <9.586, 1.015, 1.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-10.061, 2.229 - 1.015,4.012> } 
    #declare sc = <0.889, 0.586, 3.682> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-21.587, 1.392 - 0.586,52.147> } 
    #declare sc = <0.783, 0.190, 3.573> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-21.587, 0.618 - 0.190,52.147> } 
    #declare sc = <0.371, 0.360, 0.637> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-21.587, 2.290 - 0.360,52.147> } 
    #declare sc = <0.371, 0.360, 0.637> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-21.587, 2.290 - 0.360,54.507> } 
    #declare sc = <0.371, 0.360, 0.637> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-21.587, 2.290 - 0.360,49.808> } 
      }


#declare pc_small_chips =
#declare rad = .25 ;
union { 
    #declare sc = <0.654, 0.100, 0.428> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-15.404, 0.572 - 0.100,62.368> } 
    #declare sc = <0.404, 0.091, 0.731> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-17.986, 0.572 - 0.091,59.125> } 
    #declare sc = <0.404, 0.091, 0.731> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-2.525, 0.572 - 0.091,50.481> } 
    #declare sc = <0.404, 0.091, 0.731> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-2.511, 0.572 - 0.091,46.177> } 
    #declare sc = <0.404, 0.091, 0.731> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-0.842, 0.572 - 0.091,53.257> } 
    #declare sc = <0.404, 0.091, 0.731> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-0.842, 0.572 - 0.091,43.427> } 
    #declare sc = <0.654, 0.100, 0.428> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-15.404, 0.572 - 0.100,34.392> } 
    #declare sc = <0.404, 0.091, 0.731> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-18.040, 0.572 - 0.091,37.588> } 
    #declare sc = <0.834, 0.091, 1.226> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <25.658, 0.572 - 0.091,30.858> } 
    #declare sc = <0.834, 0.091, 1.226> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <25.360, 0.572 - 0.091,17.964> } 
    scale <-1,1,1>
    }
      




#declare pc_solder_points =
#declare rad = .15 ;
union { 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <2.142, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <1.509, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.220, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.853, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-1.709, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-2.342, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-1.052, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-0.419, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-5.519, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-6.152, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-7.442, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-6.809, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-4.246, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-4.879, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.590, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-2.957, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-6.809, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-7.442, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-6.152, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-5.519, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-9.326, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-9.959, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-8.669, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-8.036, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-8.036, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-8.669, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-9.959, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-9.326, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-5.519, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-6.152, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-7.442, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-6.809, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-2.957, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.590, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-4.879, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-4.246, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-6.809, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-7.442, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-6.152, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-5.519, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-0.419, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-1.052, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-2.342, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-1.709, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.853, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.220, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <1.509, 0.510 - 0.012,21.895> } 
    #declare sc = <0.202, 0.012, 7.551> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <2.142, 0.510 - 0.012,21.895> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,27.999> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,27.344> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,26.715> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,26.098> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,25.444> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,22.272> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,22.927> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,23.543> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,24.173> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,24.827> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,21.618> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,20.964> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,20.334> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,19.718> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,19.063> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,15.892> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,16.546> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,17.163> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,17.792> } 
    #declare sc = <7.724, 0.012, 0.180> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-3.896, 0.510 - 0.012,18.447> } 
    material {M_metal_chrome}
    scale <-1,.7,1>
    translate <0,.15,0> 
      }


#declare pc_edge_fin =
#declare rad = .1 ;
union { 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-9.756, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-10.389, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-7.218, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-7.851, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-9.141, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-8.508, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-5.945, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-6.578, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-5.289, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-4.656, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-1.677, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-2.310, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <3.868, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <3.235, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <1.945, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <2.578, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.672, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <1.305, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <9.982, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <9.349, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <11.255, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <10.622, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <11.912, 0.510 - 0.012,67.316> } 
    #declare sc = <0.131, 0.012, 1.489> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <12.545, 0.510 - 0.012,67.316> }
    material {M_metal_chrome}
    scale <-1,.7,1>
    translate <0,.1,0> 
    }
      


  
#declare pc_chip_leg =
union {
sphere_sweep {
     cubic_spline
     6,
     <0.000, 0.658, -.5> , 0.029
     <0.000, 0.658, -.5> , 0.029
     <0.000, 0.616, 0.306> , 0.030
     <0.000, 0.00, 0.564> , 0.028
     <0.000, -0.010, 0.928> , 0.034
     <0.000, -0.050, 0.928> , 0.036
     tolerance 0.000001  
     material {M_metal_chrome}
     scale <6,1.5,1>
     } 
     object { sphere { <0.000, -.1, 0.928> .2 scale <1,.7,1> material {M_metal_chrome} }} 
     
}

#declare pc_20_legs =
#declare i=0;
#declare c=20;
#declare gap=.64;
union {
    #while (i<c)
        #declare i=i+1;
        object { pc_chip_leg rotate <0,-90,0> translate <0,0,i*gap>}
    #end            
}

#declare pc_7_legs =
#declare i=0;
#declare c=7;
#declare gap=1.28;
union {
    #while (i<c)
        #declare i=i+1;
        object { pc_chip_leg rotate <0,-90,0> scale <1,.8,1.2> translate <0,0,i*gap>}
    #end            
}


#declare pc_10_legs =
#declare i=0;
#declare c=10;
#declare gap=.62;
union {
    #while (i<c)
        object { pc_chip_leg rotate <0,-90,0> scale <1,.6,.85> translate <0,0,i*gap>}
        #declare i=i+1;
    #end            
}

    
// -----------------------------------------------------------------------------------------
//                      R E S I S T E R S
//------------------------------------------------------------------------------------------
#declare pc_resister =
sphere_sweep {
     cubic_spline
     7,
     <-0.712, 0.000, 0.000> , 0.284
     <-0.712, 0.000, 0.000> , 0.284
     <-0.492, 0.000, 0.000> , 0.249
     <0.000, 0.000, 0.000> , 0.249
     <0.477, 0.000, 0.000> , 0.249
     <0.712, 0.000, 0.000> , 0.284
     <0.712, 0.000, 0.000> , 0.284
     tolerance 0.000001
     }    


#declare pc_resister_A = object { pc_resister material {M_pc_resisters translate <0,-2,0>} }
#declare pc_resister_B = object { pc_resister material {M_pc_resisters translate <0,-4,0>} }
#declare pc_resister_C = object { pc_resister material {M_pc_resisters translate <0,-6,0>} }
#declare pc_resister_D = object { pc_resister material {M_pc_resisters translate <0,-8,0>} }
                                                                                            
                                                                                            
// -----------------------------------------------------------------------------------------
//                      C A P A C I T O R
//------------------------------------------------------------------------------------------
#declare pc_capacitor =
#declare th = 0.5 ;
#declare sf = 2.0 ;
#declare nStrenth = -5 ;
#declare nSize = 1 ; 
union {
    blob {
         threshold th
         sphere{ <0,0,0>, 1, 1 scale <1.303, 1.303, 0.671> * sf  translate <0.000, 2.690, -0.000> }
         sphere{ <0,0,0>, 1, 1 scale <0.353, 0.471, 0.394> * sf  translate <0.7, 1.227, 0.000> }
         sphere{ <0,0,0>, 1, 1 scale <0.353, 0.471, 0.394> * sf  translate <-0.7, 1.227, 0.000> }
         material {M_pc_blue_gloss}
         } 
    object { cylinder { <0,0,0>, <0,2,0>, 0.05 translate < .7,0,0>   } } 
    object { cylinder { <0,0,0>, <0,2,0>, 0.05 translate <-.7,0,0>   } }
    object { sphere { < .7,0,0> .3 scale <1,.5,1> material {M_metal_chrome}  }}
    object { sphere { <-.7,0,0> .3 scale <1,.5,1> material {M_metal_chrome} }}     
}    

// -----------------------------------------------------------------------------------------
//                      D I O D E S 
//------------------------------------------------------------------------------------------

#declare pc_diode_A = 
union {
    difference {
        object { Round_Cylinder_Tube( <0,0,0>, <0,3,0>,1,.2, 1, 1 ) translate <0,0,0>  material {M_diode_A scale <3,3,3>}} 
        object { cylinder { <0,0,0>, <0,1.00,0>, 0.75 translate <0,2.95,0>  material {M_metal_chrome} } }
        translate <0,1,0>
    } 
    union {
        object { cylinder { <0,0,0>, <0,1,0>, 0.05 translate < .65,0,0>   } } 
        object { cylinder { <0,0,0>, <0,1,0>, 0.05 translate <-.65,0,0>   } }
        object { sphere { < .65,0,0> .3 scale <1,.5,1> material {M_metal_chrome}  }}
        object { sphere { <-.65,0,0> .3 scale <1,.5,1> material {M_metal_chrome} }}
        }
    scale <1.4,1.4,1.4>    
}


#declare pc_diode_B = 
union {
    difference {
        object { Round_Cylinder_Tube( <0,0,0>, <0,3,0>,1,.2, 1, 1 ) translate <0,0,0>  material {M_diode_B scale <3,3,3>}} 
        object { cylinder { <0,0,0>, <0,1.00,0>, 0.75 translate <0,2.95,0>  material {M_metal_chrome} } }
        translate <0,1,0> 
        
    } 
    union {
        object { cylinder { <0,0,0>, <0,1,0>, 0.05 translate < .65,0,0>   } } 
        object { cylinder { <0,0,0>, <0,1,0>, 0.05 translate <-.65,0,0>   } }
        object { sphere { < .65,0,0> .3 scale <1,.5,1> material {M_metal_chrome}  }}
        object { sphere { <-.65,0,0> .3 scale <1,.5,1> material {M_metal_chrome} }}  
        }
    scale <1.1,1.1,1.1>    
}
   
    

//--diode with light
#declare pc_diode_C = 
union { 
    union {
        object { Round_Cylinder_Tube( <0,0,0>, <0,2,0>,1,.2, 1, 1 ) translate <0,0,0>  material {M_pc_black_gloss }} 
        object { cylinder { <0,2,0>, <0,2.5,0>, 0.75 translate <0,0,0>  material {M_metal_chrome} } } 
        object { sphere { <0,0,0> .9 translate <0,3,0> material {M_glass_red} } no_shadow } 
        object { sphere { <0,0,0> .5 translate <0,3,0> material {M_red_glow}  } no_shadow }
        translate <0,1,0>
    } 
    union {
        object { cylinder { <0,0,0>, <0,1,0>, 0.05 translate < .65,0,0>   } } 
        object { cylinder { <0,0,0>, <0,1,0>, 0.05 translate <-.65,0,0>   } }
        object { sphere { < .65,0,0> .3 scale <1,.5,1> material {M_metal_chrome}  }}
        object { sphere { <-.65,0,0> .3 scale <1,.5,1> material {M_metal_chrome} }}
        }
    scale <1.1,1.1,1.1>    
}


#declare pc_bent_wire =
sphere_sweep {
     cubic_spline
     8,
     <0.000, 0.010, 0.000> , 0.4
     <0.000, 0.010, 0.000> , 0.4
     <0.000, 0.178, 0.000> , 0.10
     <0.004, 1.395, 0.000> , 0.10
     <-0.246, 1.835, 0.000> , 0.10
     <-0.771, 1.982, 0.000> , 0.10
     <-1.819, 1.982, 0.000> , 0.10
     <-1.819, 1.982, 0.000> , 0.10
     tolerance 0.000001  
     material {M_metal_chrome}
     }
     




#declare pc_wire_A =
sphere_sweep {
     cubic_spline
     12,
     <-21.568, 2.655, 54.507> , 0.143
     <-21.568, 2.655, 54.507> , 0.143
     <-21.594, 3.549, 54.651> , 0.143
     <-22.408, 4.306, 55.115> , 0.143
     <-23.624, 4.479, 55.491> , 0.143
     <-25.455, 3.947, 55.465> , 0.143
     <-28.790, 3.248, 55.264> , 0.143
     <-30.340, 2.487, 54.628> , 0.143
     <-30.511, 1.364, 54.818> , 0.143
     <-29.575, 0.470, 55.403> , 0.143
     <-25.772, -0.836, 55.631> , 0.143
     <-25.772, -0.836, 55.631> , 0.143
     tolerance 0.000001
     material {M_pc_red_gloss}
     }
     
#declare pc_wire_B =
sphere_sweep {
     cubic_spline
     12,
     <-26.333, -0.836, 53.474> , 0.143
     <-26.333, -0.836, 53.474> , 0.143
     <-29.575, 0.470, 54.389> , 0.143
     <-30.511, 1.364, 54.332> , 0.143
     <-30.340, 2.487, 53.848> , 0.143
     <-28.790, 3.248, 53.571> , 0.143
     <-25.510, 3.947, 52.972> , 0.143
     <-23.824, 4.479, 52.211> , 0.143
     <-22.607, 4.306, 52.433> , 0.143
     <-21.594, 3.549, 52.277> , 0.143
     <-21.568, 2.655, 52.133> , 0.143
     <-21.568, 2.655, 52.133> , 0.143
     tolerance 0.000001   
     material {M_pc_green_gloss}
     }



#declare pc_strap_wire =
sphere_sweep {
     cubic_spline
     13,
     <0.00, 2.655, 3.112> , 0.143
     <0.00, 2.655, 3.112> , 0.143
     <0.00, 2.342, 1.220> , 0.143
     <0.00, 2.704, -1.376> , 0.143
     <0.00, 4.419, -7.870> , 0.143
     <0.00, 5.369, -15.803> , 0.143
     <0.00, 4.410, -22.805> , 0.143
     <0.00, 1.659, -30.111> , 0.143
     <0.00, 0.307, -37.903> , 0.143
     <0.00, 0.915, -47.264> , 0.143
     <0.00, 2.376, -56.085> , 0.143
     <0.00, -0.740, -66.637> , 0.143
     <0.00, -0.740, -66.637> , 0.143
     tolerance 0.000001
     }
     
#declare pc_strap =
#declare i=0;
#declare c=30;
#declare gap=.28; 

union {  
    object { pc_strap_wire  translate <-0.28,0,0> material {M_pc_red_gloss}}
    #while (i<c)
        object { pc_strap_wire translate <i*gap,0,0> material {M_pc_gray_gloss} }
        #declare i=i+1;
    #end  
    object { pc_strap_wire  translate <8.2,0,0> material {M_pc_red_gloss}}
    scale <1.5,1,1>  translate <-16,0, 0>          
}



//--- print circuit board      
#declare pc_board =     
object {  
    union {
        object { pc_board_base material {M_pc_board_wire} }
        object { pc_chips scale <-1,1,1>  material {M_pc_chips} }
        object { pc_small_chips material {M_pc_chips} }
        object { pc_resister_A scale <3,4,4> translate <-3.8,2,9> } 
        
        object { pc_resister_B scale <2,3,3> translate <-7,2,35.52>  }
        object { pc_resister_B scale <2,3,3> translate <-7,2,38.1>  }
        
        object { pc_resister_C scale <2.3,3,3> translate <-18.1,2,63.3>  }
        object { pc_resister_C scale <2.3,3,3> translate <-18.1,2,61.2>  }  
        
        object { pc_resister_D scale <4.5,5,5> rotate <0,90,0> translate <-5.06,2,48.38>  }   
        object { pc_resister_D scale <4.5,5,5> rotate <0,90,0> translate <-1.95,2,48.38>  }  
        
       
        
        //object { pc_solder_points } 
        object { pc_edge_fin }
        object { pc_20_legs translate <-2.75,.6,15.2> } 
        object { pc_20_legs scale <-1,1,1> translate <10.4,.6,15.2> } 
        object { pc_20_legs rotate <0,-90 0> translate <10.75,.6,15.4> }
        object { pc_20_legs rotate <0,-90 0> scale <1,1,-1> translate <10.75,.6,28.4> } 
        object { pc_7_legs translate <-18.45,.6,9.6> } 
        object { pc_7_legs scale <-1,1,1> translate <-15.6,.6,9.6> }
        object { pc_7_legs translate <-18.45,.6,22.62> } 
        object { pc_7_legs scale <-1,1,1> translate <-15.6,.6,22.62> }
        object { pc_7_legs translate <-18.45,.6,36.87> } 
        object { pc_7_legs scale <-1,1,1> translate <-15.6,.6,36.87> }
        object { pc_7_legs translate <-18.45,.6,49.67> } 
        object { pc_7_legs scale <-1,1,1> translate <-15.6,.6,49.67> } 
        
         
        object { pc_10_legs translate <8.41,.6,39.43> } 
        object { pc_10_legs scale <-1,1,1> translate <14.9,.6,39.43> } 
        object { pc_10_legs translate <8.41,.6,51.53> } 
        object { pc_10_legs scale <-1,1,1> translate <14.9,.6,51.53> }
        
        object { pc_10_legs rotate <0,-90,0> translate <14.3,.55,39> } 
        object { pc_10_legs rotate <0,-90,0> translate <14.3,.65,51> }
       
        
        object { pc_diode_A scale <1,1,1> translate <-11.48,.6,50.5> }   
        object { pc_diode_A scale <1,1,1> translate <-11.48,.6,46.1> }
        object { pc_diode_B scale <1,1,1> rotate <0,90,0> translate <22,.6,26.73> }   
        object { pc_diode_B scale <1.3,1.3,1.3> rotate <0,0,0> translate <4.87,.6,37.34> } 

        object { pc_bent_wire scale <1,.8,1> rotate <0,180,0> translate <-9.75,.5,35.52> }
        object { pc_bent_wire scale <1,.8,1> rotate <0,0,0> translate <-4.16,.5,35.52> }  
        object { pc_bent_wire scale <1,.8,1> rotate <0,180,0> translate <-9.75,.5,38.1> }
        object { pc_bent_wire scale <1,.8,1> rotate <0,0,0> translate <-4.16,.5,38.1> } 
        
        
        //wires for pc_resister_
        object { pc_bent_wire scale <1,.8,1> rotate <0,180,0> translate <-21,.5,61.2> }
        object { pc_bent_wire scale <1,.8,1> rotate <0,0,0> translate <-15.35,.5,61.2> }
        object { pc_bent_wire scale <1,.8,1> rotate <0,180,0> translate <-21,.5,63.3> }
        object { pc_bent_wire scale <1,.8,1> rotate <0,0,0> translate <-15.35,.5,63.3> }    
        object { pc_bent_wire scale <1,.8,1> rotate <0,180,0> translate <-7.56,.5,8.93> }
        object { pc_bent_wire scale <1,.8,1> rotate <0,0,0> translate <-0.33,.5,8.93> } 
        object { pc_bent_wire scale <1,.8,1> rotate <0,90,0> translate <-5.06,.5,42.49> }
        object { pc_bent_wire scale <1,.8,1> rotate <0,90,0> translate <-1.95,.5,42.49> }  
        object { pc_bent_wire scale <1,.8,1> rotate <0,-90,0> translate <-5.06,.5,53.79> }
        object { pc_bent_wire scale <1,.8,1> rotate <0,-90,0> translate <-1.95,.5,53.79> } 
       
        object { pc_capacitor scale <1,1,.6> rotate <0,-45,0> translate <20.76,.5,38.22> }
        object { pc_capacitor scale <1,1,.6> rotate <0,-45,0> translate <18.57,.5,33.48> } 
        
        object { pc_wire_A scale <-1,1,1> rotate <0,0,0> translate <0,0,0> }
        object { pc_wire_B scale <-1,1,1> rotate <0,0,0> translate <0,0,0> }
                    
        object { pc_strap scale <-1,1,1> rotate <0,0,0> translate <0,0,0> }  
        
        object { pc_diode_C scale <.8,.8,.8> rotate <0,90,0> translate <24,.6,9.37> }
        
         
  }
}
 



