

//--- C O L O R S
#ifndef (Transparent) #declare Transparent = rgbt 1 ;#end
#declare C_white =          color rgb<1,1,1>  ;
#declare C_black =          color rgb<0,0,0>  ;
#declare C_red =            color rgb<1,0,0>  ;  
#declare C_red_dark =       color rgb<.9,0,0>  ;
#declare C_green =          color rgb<0,1,0>  ;
#declare C_blue =           color rgb<0,.5,.9>  ;
#declare C_orange =         color rgb<1,1,0>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_silver =         color rgb <0.85, 0.85, 0.8>;   
#declare C_gold =           color red 0.82 green 0.6 blue 0.196078;
#declare C_gold_bright=     color <0.90, 0.65, 0.15>;
#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 
#declare C_light_green =    color rgb<.75,1,.9>  ;
#declare C_gray10 =         color red 0.1 green 0.1 blue 0.1;   
#declare C_gray20 =         color red 0.2 green 0.2 blue 0.2;
#declare C_gray30 =         color red 0.3 green 0.3 blue 0.3; 
#declare C_gray40 =         color red 0.4 green 0.4 blue 0.4;
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;
#declare C_gray60 =         color red 0.6 green 0.6 blue 0.6; 
#declare C_gray70 =         color red 0.7 green 0.7 blue 0.7;   
#declare C_gray80 =         color red 0.8 green 0.8 blue 0.8; 
#declare C_gray90 =         color red 0.9 green 0.9 blue 0.9;
#declare C_tan =            color red 0.85 green 0.66 blue 0.5;
#declare C_tan_dark =       color red 0.66 green 0.5 blue 0.4;
#declare RGB_green_olive =  rgb <0.4, 0.6, 0.2> ;
#declare RGB_green_gray =   rgb <0.5, 0.6, 0.4> ; 
#declare RGB_yellow_gray =  rgb <0.7, 0.8, 0.4> ;
#declare RGB_brown_gray =   rgb <0.879, 0.55, 0.32> ;  
#declare C_brown_gray =     color red 1 green 0.6 blue 0.32 ; 
#declare C_teal =           color rgb<.30,.51,.54> ;
#declare C_purple =         color red 0.18 green 0 blue 0.26;
#declare C_teal =           color red 0.0 green 0.64 blue 1.0;  
#declare C_skylight_blue =  color red .10 green .15 blue .2 ;
#declare C_skylight_warm =  color red .06 green .04 blue .03 ;
#declare C_dark_gray_blue = color red .04 green .08 blue .10 ;      
#declare C_gray_blue =      color red .04 green .06 blue .07 ;
#declare C_dark_cyan =      color red 0 green.07 blue .11 ; 

#declare C_water = colour red .03 green .04 blue .05 filter 1 ;
#declare C_water_fade_A = colour red .05 green .06 blue .07 filter .2 ;
#declare C_water_fade_B = colour red .05 green .06 blue .07 filter .2 ;
#declare C_water_fade_C = colour red .05 green .06 blue .07 filter .2 ;

#declare f = .0039  ;                             
#declare tR = 107*f ;
#declare tG = 176*f ;
#declare tB = 189*f ;
#declare C_teal = color rgb<tR,tG,tB> ;



#declare C_red50 = rgbf<1,0,0,.5>;
#declare C_ground_gray_cool = rgb <0.17, 0.20, 0.15> ;      
#declare C_ground_gray_dark = rgb <0.11, 0.1, 0.12> ;
#declare C_ground_gray_brown = rgb <0.4, 0.25, 0.15> ;
#declare C_ground_gray_green = rgb <0.3, 0.34, 0.29> ;
#declare C_ground_gray_sage= rgb <0.6, 0.4, 0.15> ;
#declare C_ground_gray_gold= rgb <0.8, 0.75, 0.2> ;  
#declare C_ground_gray_cream= rgb <0.8, 0.75, 0.6> ; 

#declare C_rust =               color rgb <0.40, 0.40, 0.45> ;
#declare C_rust_dark =          color rgb <0.32, 0.31, 0.30>  ;

#declare C_teal_gray = color <0.48, 0.42, 0.40> *.35 ; 
#declare C_teal_gray2 = color <0.48, 0.50, 0.41> *.55 ;
#declare C_seabottom_sage = rgb <0.46, 0.54, 0.35> ; 
#declare C_seabottom_teal = rgb <0.67, 0.76, 0.67> ; 
#declare C_seabottom_gold = rgb <0.95, 0.40, 0.15> ; 

#declare C_gray_teal_dark = rgb <0.08, 0.13, 0.10> ; 
#declare C_gray_teal = rgb <0.13, 0.17, 0.18> ;


#declare C_clear = colour red 0.0 green 0.0 blue 0.0 transmit 1 ;
                   
                      
// --- C O L O R    M A P S  

#declare C_map_enviroment_sunny =
    color_map {
        [ 0.0     C_gray60 ]  
        [ 0.40    C_white ]
        [ 0.50    C_horizon_blue ]
        [ 0.53    C_light_blue ]
        [ 1.0     C_blue ]
        }
   
        
      
#declare C_map_teal = 
        color_map {
            [0.000 rgb C_teal]
            [0.2 rgbt <tR, tG, tB, .1>]
            [0.7 rgbt <tR, tG, tB, .1>]
            [0.85 rgb C_teal]
            [1.000 rgb C_teal]
        } 
                          
#declare C_map_agate_A =
    color_map {
        [ 0.0     RGB_green_olive ]
        [ 0.3     RGB_green_gray ]
        [ 0.5     RGB_yellow_gray ]
        [ 0.7     RGB_brown_gray ]
        [ 1.0     RGB_green_olive ]
        }
        

#declare C_map_mud_A = 
        color_map {
            [0.000 rgb <0.625, 0.659, 0.455>]
            [0.171 rgb <0.582, 0.449, 0.320>]
            [0.274 rgb <0.157, 0.151, 0.122>]
            [0.393 rgb <0.625, 0.619, 0.455>]
            [0.564 rgb <0.582, 0.519, 0.420>]
            [0.701 rgb <0.482, 0.392, 0.278>]
            [1.000 rgb <0.625, 0.659, 0.455>]
        }



#declare C_map_steel = 
        color_map {
            [0.000 rgb <0.535, 0.525, 0.535>]
            [0.171 rgb <0.549, 0.549, 0.520>]
            [0.274 rgb <0.457, 0.451, 0.462>]
            [0.393 rgb <0.625, 0.625, 0.625>]
            [0.564 rgb <0.582, 0.540, 0.520>]
            [0.701 rgb <0.552, 0.532, 0.578>]
            [1.000 rgb <0.535, 0.525, 0.535>]
        }


#declare C_map_steel = 
        color_map {
            [0.000 rgb <0.535, 0.525, 0.535>]
            [0.171 rgb <0.549, 0.549, 0.520>]
            [0.274 rgb <0.557, 0.551, 0.562>]
            [0.393 rgb <0.625, 0.625, 0.625>]
            [0.564 rgb <0.582, 0.540, 0.520>]
            [0.701 rgb <0.552, 0.532, 0.578>]
            [1.000 rgb <0.535, 0.525, 0.535>]
        }
        
        
#declare C_map_gold = 
        color_map {
            [0.000 rgb <0.70, 0.60, 0.45>]
            [0.171 rgb <0.65, 0.55, 0.35>]
            [0.274 rgb <0.58, 0.35, 0.25>]
            [0.393 rgb <0.65, 0.65, 0.35>]
            [0.564 rgb <0.55, 0.45, 0.25>]
            [0.701 rgb <0.65, 0.55, 0.35>]
            [1.000 rgb <0.70, 0.60, 0.45>]
        }

#declare C_shroom_grad_A =
        color_map {
			[0.0 color C_gold]  
			[0.5 color C_gold]  
			[.7 color C_white]  
			[.9 color C_tan_dark]
			[1.0 color C_tan_dark]

}     
        
        
#declare C_shroom_grad_B =
        color_map {
			[0.0 color C_horizon_blue]  
			[0.2 color C_gold]  
			[.7 color C_gold]  
			[.9 color C_horizon_blue]
			[1.0 color C_horizon_blue]

}          



#declare CM_purple_teal = 
         color_map {  
             [0.0 .5 color C_black color C_light_blue]
             [0.5 1.0 color C_light_blue color C_black]    
          }
          
#declare CM_sky_dome_teal_purple_2 = 
         color_map {  
             [0.0 .5 color C_teal color C_purple]
             [0.5 1.0 color C_purple color C_teal]    
          }



#declare CM_sky_dome_brown_blue =
         color_map { 
             [0.0 .5 color C_teal color C_brown_gray]
             [0.5 1.0 color C_brown_gray color C_teal]  
          }

#declare CM_sky_dome_blue_violet = 
         color_map { 
             [0.0 .1 color C_teal color C_teal] 
             [0.1 .5 color C_teal color C_horizon_blue]
             [0.5 .9 color C_horizon_blue color C_teal]  
             [0.9 1.0 color C_teal color C_teal]  
          }

              
#declare CM_sky_dome_teal_purple = 
         color_map { 
             [0.0 .1 color C_teal color C_teal] 
             [0.1 .5 color C_teal color C_purple]
             [0.5 .9 color C_purple color C_teal]  
             [0.9 1.0 color C_teal color C_teal]  
          }





#declare CM_water_fade = 
        color_map {
            [0.000 C_water]
            [0.171 C_water]
            [0.274 C_water_fade_A]
            [0.393 C_water_fade_B]
            [0.564 C_water]
            [0.701 C_water_fade_C]
            [1.000 C_water]
        }

 
// -- P I G M E N T S 
//  granite
//  waves 
//  wrinkles 
//  bozo            
//  leopard     
//  crackle  
//  agate            
//  agate_turb 0.3   
#declare P_mud_granite = pigment { granite color_map {  C_map_mud_A } scale 1 warp { turbulence .5 }} 
#declare P_mud_leopard = pigment { leopard color_map {  C_map_mud_A } scale 1 warp { turbulence 3 }} 
#declare P_mud_bozo = pigment { bozo color_map {  C_map_mud_A } scale 1 warp { turbulence 3 }} 
#declare P_mud_wrinkles = pigment { wrinkles color_map {  C_map_mud_A } scale 1 warp { turbulence 3 }} 
#declare P_mud_crackle = pigment { crackle color_map {  C_map_mud_A } scale 1 warp { turbulence 3 }} 
#declare P_mud_agate = pigment { agate color_map {  C_map_mud_A } scale 1 warp { turbulence 1 }} 
#declare P_steel_leopard = pigment { leopard color_map {  C_map_steel } scale 1 warp { turbulence 2 }} 
#declare P_steel_bozo = pigment { bozo color_map {  C_map_steel } scale 1 warp { turbulence 4 }} 
#declare P_steel_wrinkles = pigment { wrinkles color_map {  C_map_steel } scale 1 warp { turbulence 6 }} 
#declare P_steel_agate = pigment { agate color_map {  C_map_steel } scale 1 warp { turbulence 5 }} 
#declare P_gold_agate = pigment { agate color_map {  C_map_gold } scale 1 warp { turbulence 5 }} 
#declare P_clear_black = pigment { color C_black transmit 1 }
#declare P_clear_white = pigment { color C_white transmit 1 }




// -- N O R M A L S
#declare N_frost = normal {bumps 0.3 scale .001} 
#declare N_ripple_A = normal { bozo 0.2 scale 0.2 }  
#declare N_ripple_large = normal{N_ripple_A scale 10 bump_size 5}
#declare N_small_bumps = normal { leopard bump_size 10 scale 1 warp { turbulence 1 }}
#declare N_granite = normal { granite 1 bump_size 1 scale 1 warp { turbulence .5 }} 
#declare N_leopard = normal { leopard bump_size 9 scale .5 warp { turbulence 6 }} 
#declare N_mud_bozo = normal { bozo bump_size 5 scale 1 warp { turbulence 3 }} 
#declare N_mud_wrinkles = normal { wrinkles bump_size 2 scale 1 warp { turbulence 3 }} 
#declare N_mud_crackle = normal { crackle bump_size 2 scale 1 warp { turbulence 3 }}  
#declare N_mud_agate = normal { agate bump_size 2 scale 1 warp { turbulence 1 }} 
#declare N_steel = normal { leopard bump_size 3 scale 1 warp { turbulence 2 }}
#declare N_steel_bozo = normal { bozo bump_size 1 scale 1 warp { turbulence 4 }}  
#declare N_steel_wrinkles = normal { wrinkles bump_size .5 scale 1 warp { turbulence 8 }}
#declare N_steel_agate = normal { agate bump_size .05 scale 1 warp { turbulence 5 }} 
#declare N_gold_agate = normal { agate bump_size .2 scale 1 warp { turbulence 5 }} 



#declare N_caos_A =
normal {
   gradient x       
    normal_map {
        [0.3  bumps scale 2]
        [0.3  dents]
        [0.6  dents]
        [0.9  marble turbulence 1]
        }
        
 }       
 
 
#declare N_ripple_A = 
normal {
  gradient x                // this is the PATTERN_TYPE
  slope_map {
    [0    <0.5, 1>]   // start in middle and slope up
    [0.25 <1.0, 0>]   // flat slope at top of wave
    [0.5  <0.5,-1>]   // slope down at mid point
    [0.75 <0.0, 0>]   // flat slope at bottom
    [1    <0.5, 1>]   // finish in middle and slope up
    } 
    scale .2
} 




     
                  
//--- F I N I S H E S   P L A S T I C
/*
FINISH:
  finish { [FINISH_IDENTIFIER] [FINISH_ITEMS...] }
FINISH_ITEMS:
  fresnel FLOAT
  ambient COLOR | diffuse [albedo] Amount [, Amount] |
  emission COLOR | brilliance Amount | phong [albedo] Amount | phong_size Amount |
  specular [albedo] Amount | roughness Amount | 
  metallic [Amount] | reflection COLOR |
  crand Amount | conserve_energy BOOL |
  reflection { Color_Reflecting_Min [REFLECTION_ITEMS...] } |
  subsurface { translucency COLOR } |
  irid { Irid_Amount [IRID_ITEMS...] |
  use_alpha BOOL
  }
REFLECTION_ITEMS:
  COLOR_REFLECTION_MAX | fresnel BOOL |
  falloff FLOAT_FALLOFF | exponent FLOAT_EXPONENT |
  metallic FLOAT_METALLIC
IRID_ITEMS:
  thickness Amount | turbulence Amount

*/ 


#declare F_plastiC_gloss =    
    finish {
    reflection {.3, .8 fresnel on } 
    conserve_energy 
    brilliance 6
    ambient 1
    diffuse 1 
    phong 5    
    phong_size 20
    specular .3 
    roughness .2
    reflection .2 
    } 
         
#declare F_plastic_satin =    
    finish {
    reflection {.5, 1 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 0
    brilliance 2
    diffuse 1 
    phong .2    
    phong_size 100
    //metallic
    specular .1 
    roughness .9
    reflection .1 
    }        
     

#declare F_soft =    
    finish {
    reflection {.4,.6 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 1
    brilliance 2
    diffuse .7 
    phong .3    
    phong_size 40
    //metallic
    specular .1 
    roughness .9
    reflection .1 
    } 
    
    
#declare F_silk =    
    finish {
    reflection {.5, 1 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 1
    brilliance 2
    diffuse 1 
    phong .2    
    phong_size 20
    //metallic
    specular .01 
    roughness .75
    reflection .2 
    }            
    
#declare F_flat =            
  finish {
    ambient 0.0 
    diffuse 1
    phong 0
    phong_size 0
    specular 0
    metallic 0
  }
       
       
 #declare F_bright =            
  finish {
    ambient 1 
    diffuse 1
    phong 0
    phong_size 0
    specular 0
    metallic 0  
    emission rgb .3
  }
        
        
        
        
        
        
//--- F I N I S H E S   M E  T A  L
  
#declare F_dull_glow =
    finish {
    ambient 0
    //emission .1
    //fresnel 1
    phong 0
    diffuse albedo 1
    specular albedo 1 
    roughness 0.01
    reflection .5
    } 
  
  

#declare F_glow =
    finish {
    ambient 0
    emission 1
    //fresnel 1
    phong 0
    diffuse albedo .5
    specular albedo 1 
    roughness 0.001
    reflection 1
    }           
    


#declare F_metal_dull  =
finish {
     reflection {.3, 1 fresnel on } 
     conserve_energy 
     brilliance 5   
     ambient 1
     diffuse 1
     phong .1    
     phong_size 200   
     metallic 1
     specular .8 
     roughness .1  
     reflection .15  
}


#declare F_metal_hard  =
finish {  
    reflection {.01, 1 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 0
    brilliance 5
    diffuse 1 
    phong 2    
    phong_size 100
    metallic
    specular 1 
    roughness 1/100
    reflection .2
} 

#declare F_metal_hard2  =
finish {  
    reflection {.01, 1 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient .1
    brilliance 5
    diffuse 1 
    phong 2    
    phong_size 100
    metallic
    specular 1 
    roughness .2
    reflection .1
}

#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}


#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}


#declare F_metal_smooth =    
    finish {
    reflection {.3, .6 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 0
    brilliance 2
    diffuse 1 
    phong 1    
    phong_size 100
    metallic
    specular .5
    roughness .15
    }  
            
            
            
#declare F_metal_flat =
    finish {
        reflection {0, 1 fresnel on falloff 1.0 exponent 1.0 metallic 0 } 
        conserve_energy
        phong .5     
        phong_size 10 
        diffuse .5  
        metallic 1
        specular .7 
        roughness .2
        }
             
             
             
#declare F_stone_smooth =
    finish {
        reflection {.1, .3 
            fresnel on 
            falloff 1 
            exponent 1.0 
            metallic 0 
            } 
        conserve_energy
        phong .3     
        phong_size 30 
        diffuse .75 
        specular .2 
        roughness .8
        }        
          

//--- F I N I S H E S   G L A S S

#declare F_glass =
  finish {
    specular 0.7
    roughness 0.001
    ambient .5
    diffuse .5
    reflection { .2, 1.0 fresnel on }
    conserve_energy
  } 
  
#declare F_glass_dark =
  finish {
    specular .02
    roughness 0.01   
    phong 1     
    phong_size 100  
    ambient .5
    diffuse 0
    reflection { .2, 1.0 fresnel on }
    conserve_energy
  } 
  
  #declare F_hazy_glass =
     finish {
     reflection {0, .85 fresnel on } 
     conserve_energy
     phong 10     
     phong_size 60   
     metallic 1
     specular 30 
     roughness 1/10 
    }
          

  #declare F_hard_glass =
     finish {
     reflection {.2, 1 fresnel on } 
     conserve_energy
     phong 5     
     phong_size 100   
     metallic 0
     specular .25 
     roughness 1/10  
     diffuse 1
    }

  #declare F_milky =
     finish {
     reflection {.4, .6 fresnel on } 
     conserve_energy
     phong 1     
     phong_size 60   
     metallic 0
     specular .2 
     roughness 1/10 
    }
    


//---  I N T E R I O R S     


 #declare I_white=
  interior {
    ior 1.5  
    fade_colour <1,1,1>
    fade_distance 1.0
    fade_power .2
  }

 #declare I_clear=
  interior {
    ior 1.5  
    fade_colour <1,1,1>
    fade_distance 1.0
    fade_power .2
  }

 #declare I_dark=
  interior {
    ior 1.5  
    fade_colour <.5,.5,.5>
    fade_distance 1.0
    fade_power .2
  }
  
 #declare I_green =
    interior {
        ior 1.6
        fade_colour <0,.7,.2>
        fade_distance .5
        fade_power 2
        }  
        
 #declare I_green_light =
    interior {
        ior 1.6
        fade_colour <.75,1,.9>
        fade_distance .5
        fade_power 2
        }        

 #declare I_blue =
    interior {
        ior 1.6
        fade_colour <0,.8,1>
        fade_distance .5
        fade_power 2
        }
 
 
 #declare I_red =
    interior {
        ior 1.6
        fade_colour <1,0,0>
        fade_distance .5
        fade_power 2
        }  


 #declare I_gold =
    interior {
        ior 1.6
        fade_colour <0.90, 0.65, 0.15>
        fade_distance .5
        fade_power 2
        } 
        
        
 #declare I_solid =
    interior {
        ior 1
        fade_colour <0,0,0>
        fade_distance 0
        fade_power 0
        }      
        


//--- T E X T U R E S   G R A Y 
                       
#declare T_black = texture{ pigment{ rgb C_black transmit 0 }}
#declare T_gray10 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray20 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray30 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray40 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray50 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray60 = texture{ pigment{ rgb C_gray60 transmit 0 }}  
#declare T_gray70 = texture{ pigment{ rgb C_gray70 transmit 0 }}
#declare T_gray80 = texture{ pigment{ rgb C_gray80 transmit 0 }}
#declare T_white = texture{ pigment{ rgb C_white transmit 0 }}  
#declare T_tan = texture{ pigment{ rgb C_tan transmit 0 }}   
#declare T_tan_dark = texture{ pigment{ rgb C_tan_dark transmit 0 }}  
#declare T_red = texture{ pigment{ rgb C_red transmit 0 }}   


//-- T E X T U R E S    E N V I R O M E N T

#declare T_enviroment_sunny =
    texture {
     pigment {
        gradient z 
            color_map { 
                C_map_enviroment_sunny
             }
         }
    }



// T E X T U R E S   L A Y E R E D

#declare T_agate_gold_vien = 
texture {
  bozo
  texture_map {
    [0.30  pigment {
             color rgb <.3,.5,.5>
             transmit 1
           }               
         ]
    [0.5   pigment {
             granite
             color_map {  C_map_agate_A }
             scale 3
             warp {
             turbulence 0.5
             } 
             
           }
           finish{F_metal_hard}
           normal {
             granite .6
             scale 20 
             bump_size 1 
             
           } 
                       
         ] 
        }  

  warp {
    turbulence <2.0, 3.0, 2.0>  

  }  

}





#declare T_map_steel = 
texture {
  granite
  texture_map {
    [.2  pigment {
             color rgb <.77,.77,.75>
             transmit 0
           }
           finish{F_metal_flat}
  
         ]
    [.28   pigment {
             spotted
             color_map {  C_map_steel }
             scale 1
             warp {
             turbulence 0
             } 
             
           }
           finish{F_metal_hard}
             
         ]
      [.30  pigment {
             color rgb <.8,.8,.8>
             transmit 0
           }
           finish{F_metal_flat}
  
         ]
          
        }  

  warp {
    turbulence <1.0, 10.0, 20.0>  

  }  

}


     
       
        
#declare T_shroom_texture_A =
texture {
 pigment { 
    gradient y    
    color_map {C_shroom_grad_A}
    }
    finish {
        ambient .2 
        diffuse .8
        phong .3
        phong_size 50  
        reflection .1
    }  
        normal { crackle 5 scale .1 turbulence 0.25 bump_size .5}
}
       
      
       
#declare T_shroom_texture_B =
texture {
 pigment { 
    gradient y    
    color_map {C_shroom_grad_B}
    }
    finish {
        specular 1 
        diffuse 1  
        roughness 0.0001
        phong 0.1
        phong_size 45
        brilliance 3
        reflection {0.03, .3 fresnel on}
        conserve_energy
    }  
        normal { crackle 5 scale .1 turbulence 0.25 bump_size .5}
}      
       
       
       
#declare T_shroom_A =
texture { 
    T_shroom_texture_A 
    scale .5 
    translate <0,0,0>
    } 
     
texture{
  pigment{ crackle
           scale .1 turbulence 0.25
           color_map{
			[0.0 color C_black transmit 0.39]  
			[0.05 color Transparent] 
			[0.9 color C_red]
			[.95 color Transparent]
			[1.0 color C_black transmit 0.39]
             } // end of color_map
         } // end of pigment 
         
          normal { crackle 5 scale .1 turbulence 0.25 }
}


#declare T_shroom_B =
texture { 
    T_shroom_texture_B 
    scale .5 
    translate <0,0,0>
    } 
     
texture{
  pigment{ crackle
           scale .1 turbulence 0.25
           color_map{
			[0.0 color C_black transmit 1]  
			[0.05 color Transparent] 
			[0.9 color C_red]
			[.95 color Transparent]
			[1.0 color C_black transmit 1]
             } // end of color_map
         } // end of pigment 
         
          normal { crackle 5 scale .1 turbulence 0.25 }
}

#declare M_shroom = material { 
    //texture { T_shroom_texture_A scale 1}
    texture { T_shroom_texture_B scale 1}
   }


//--- T E X T U R E S   G L A S S 
#declare T_clear_black = texture { pigment { P_clear_black }}
#declare T_clear_white = texture { pigment { P_clear_white }}


  



//--- T E X T U R E S   C O L O R S   T R A N S M I T
#declare T_red_transmit = texture{ pigment{ rgb C_red transmit 1 }} 


//--- T E X T U R E S   C O L O R S
#declare T_gold = texture{ pigment{ rgb C_gold transmit 0 }} 
#declare T_gold_bright = texture{ pigment{ rgb C_gold_bright transmit 0 }} 





#declare T_dirty_red = 
texture{
  pigment{ bozo
           scale .7 turbulence 0.15
           color_map{
			[0.0 color C_red ]  
			[0.3 color C_red]
			[0.4 color C_red_dark] 
			[0.5 color C_red_dark]
			[.7 color C_red]
			[1.0 color C_red ]
             } 
         }  
         
          //normal { crackle 5 scale .1 turbulence 0.25 }
}


#declare T_blue_clipped_paint = 
    texture {
         pigment{ rgb C_gray60 } 
         finish { F_metal_smooth }
         }

    texture{
      pigment{ wrinkles  
               scale 2 turbulence 0.15
               color_map{
    			[0.0 color C_gray70 transmit .3]  
    			[0.1 color C_gray70 transmit .1]
    			[0.3 color C_gray70 transmit .2] 
    			[0.5 color C_gray70 transmit .5]
    			[.8 color C_gray70 transmit .1]
    			[1.0 color C_gray70 transmit .3]
                 } 
             }  
           //finish { F_metal_smooth }
           normal { wrinkles  scale 1 turbulence 0.15 bump_size 5 }
    }








// --------------------------------------------------------------------------------------------------------------------------
// M A T E R I A L S   
   



// neutrals  
#declare M_neutral_floor = material{ texture{ T_gray40   finish{F_metal_hard}} interior{I_solid} } 
#declare M_tan_gloss = material{ texture{ T_tan   finish{F_plastiC_gloss}} interior{I_solid} }
#declare M_tan_dark_gloss = material{ texture{ T_tan_dark   finish{F_metal_hard}} interior{I_solid} }
#declare M_tan_dark_satin = material{ texture{ T_tan_dark   finish{F_plastic_satin}} interior{I_solid} }   
#declare M_red_gloss = material{ texture{ T_red   finish{F_plastiC_gloss}} interior{I_solid} }
#declare M_black_gloss = material{ texture{ T_black   finish{F_plastiC_gloss}} interior{I_solid} }
#declare M_gray20_gloss = material{ texture{ T_gray20   finish{F_metal_hard}} interior{I_solid} }
#declare M_gray30_gloss = material{ texture{ T_gray30   finish{F_metal_hard}} interior{I_solid} }
#declare M_gray50_gloss = material{ texture{ T_gray50   finish{F_plastiC_gloss}} interior{I_solid} } 
#declare M_gray50_mat = material{ texture{ T_gray50   finish{F_flat}} interior{I_solid} } 
#declare M_gray50_satin = material{ texture{ T_gray50   finish{F_plastic_satin}} interior{I_solid} }
#declare M_white_gloss = material{ texture{ T_white   finish{F_metal_hard}} interior{I_solid} }


// metals
#declare M_metal_alum = material{ texture{ T_gray80   finish{F_metal_dull}} interior{I_solid} }
#declare M_metal_steel = material{ texture{ T_gray70   finish{F_metal_hard}} interior{I_solid} } 
#declare M_metal_steel2 = material{ texture{ T_map_steel } scale 15} 
#declare M_metal_chrome = material{ texture{ T_gray80   finish{F_metal_polished}} interior{I_solid} }
#declare M_metal_gold = material{ texture{ T_gold   finish{F_metal_polished}} interior{I_solid} }
#declare M_metal_gold_bright = material{ texture{ T_gold_bright   finish{F_metal_polished}} interior{I_solid} } 


// glass 
#declare M_glass = material{ texture{ T_clear_black   finish{F_hard_glass}} interior{I_clear} }  
#declare M_glass_dark = material{ texture{ T_clear_black   finish{F_hard_glass}} interior{I_dark} }
#declare M_glass_red = material{ texture{ T_clear_black   finish{F_hard_glass}} interior{I_red} }





                       
                             


// --- C L O U D S  
#declare M_bozo_cloud_A = 
material {  
    texture {
        pigment {
              bozo
              turbulence 0.6
              colour_map {
                 [0.0 0.3   colour red 1.0 green 1.0 blue 1.0 filter 1.0
                            colour red 1.0 green 1.0 blue 1.0 filter 1.0]
                 [0.3 0.8   colour red 1.0 green 1.0 blue 1.0 filter 1.0
                            colour red 1.0 green 1.0 blue 1.0 filter .6]
                 [0.8 1.001 colour red 1.0 green 1.0 blue 1.0 filter .6
                            colour red 1.0 green 1.0 blue 1.0 filter 0]
              }
        }  
       finish {
          ambient 0
          diffuse 0 
          emission 1
       }
    }
} 


#declare M_water_A = 
    material {
        texture {
            pigment {
                  bozo
                  turbulence 0.4
                  colour_map { CM_water_fade }
                } 
            normal {
                //ripples .5 
                dents 1
                frequency 3 
                bump_size 1
            }
            finish {
     
                reflection {0.35, 1 fresnel}
                conserve_energy
            }
        }
    } 


    
#declare M_water_A = 
    material {
        texture {
            pigment{ rgbf <0.10, 0.09, 0.12, 0> }
            normal {
                //ripples .5 
                dents 1
                frequency 3 
                bump_size 1
            }
            finish {
                //reflection {0.7, 1 fresnel}       
                reflection {0.6, 1 fresnel}
                conserve_energy
            }
        }
        scale 1
    }
    
    
    
//---------------------------------------------------------------------------------------------------------------------------
//                                                 PIPE MATERIAL     
//---------------------------------------------------------------------------------------------------------------------------



#declare C_map_rust = 
    color_map {
        [0.0        C_rust]
        [0.1        C_rust_dark]
        [0.3        C_rust_dark] 
        [0.55       C_rust]
        [0.85       C_rust * 1.5]
        [0.9        C_rust_dark]
        [1.000      C_rust]
    }


#declare C_map_rust_clear = 
    color_map {
        [0.0        C_rust                  transmit 1]
        [0.1        C_rust_dark             transmit 1]
        [0.3        C_rust_dark             transmit 1] 
        [0.55       C_rust                  transmit 1]
        [0.85       C_rust * 1.5]
        [0.9        C_rust_dark]
        [1.000      C_rust                  transmit 1]
    }



#declare N_ripple = 
normal {
  gradient x            
  slope_map {
    [0    <0.5, 1>]  
    [0.25 <1.0, 0>]  
    [0.5  <0.5,-1>]  
    [0.75 <0.0, 0>]  
    [1    <0.5, 1>] 
    } 
}

#declare N_small_bumps = 
normal { 
    bozo 
    bump_size 10 
    scale 1 
    warp { turbulence 1 } 
    bump_size .5
    }

#declare N_flakes = 
normal { 
    wrinkles 
    bump_size 10 
    scale .07
    warp { turbulence 1 } 
    bump_size .5
    }

    
#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/10
    reflection .1   
}

#declare F_rough_paint =
finish {
    phong .3     
    phong_size 30 
    diffuse .75 
    specular .2
    reflection .2 
}
              
#declare t_gold = 
texture { 
    pigment { 
        color <0.60, 0.65, 0.55> 
        } 
    normal {
        N_small_bumps
        scale .02
        } 
    finish{
        F_metal_polished
    } 
}

     
#declare T_rust =
#declare sz = .1;   
#declare turb = .1; 
#declare bump = .8;  //over the top
 
texture { 
    pigment { 
        granite 
        color_map {C_map_rust} 
        turbulence turb
        scale sz
        } 

    finish{  
        ambient .1
        diffuse 1
        phong .5
        phong_size 50 
        }
    normal {
         granite 
         turbulence turb 
         bump_size bump
         scale sz
     }   
}


#declare T_rust_brush =
#declare sz = .2;   
#declare turb = .11; 
#declare bump = 1;  //over the top
 
texture { 
    pigment { 
        crackle 
        color_map {C_map_rust} 
        turbulence turb
        scale sz
        } 

    finish{  
        ambient .1
        diffuse 1
        phong .5
        phong_size 50 
        }
    normal {
         crackle 
         turbulence turb 
         bump_size bump
         scale sz
     }
     rotate z*90   
}


#declare T_rust_dent =
#declare sz = .2;   
#declare turb = 3; 
#declare bump = 1.5;  //over the top
 
texture { 
    pigment { 
        crackle 
        color_map {C_map_rust_clear} 
        turbulence turb
        scale sz
        } 

    finish{  
        ambient .1
        diffuse 1
        phong .5
        phong_size 30 
        reflection {0.35, .3 fresnel}
        conserve_energy
        }
    normal {
         leopard 
         turbulence turb  
         bump_size bump
         scale sz/20
     }
     rotate z*90   
}





   
 
#declare T_teal_cutout =  

#declare sz = .2;   
#declare turb = 0.05; 
#declare bump = 1;  //over the top
    texture {
        pigment {  
           spotted
           color_map{
			[0.00 color  C_clear ]  
			[0.40 color  C_clear ]
			[0.40 color  C_gray_teal_dark ]
			[0.44 color  C_gray_teal ]
			[0.76 color  C_gray_teal ] 
			[0.80 color  C_gray_teal_dark ]
			[0.80 color  C_clear ]
			[1.00 color  C_clear ]
             } 
        scale sz
        warp { turbulence turb }
        
        }
     
     
     
     finish{
        ambient .2
        diffuse .9
        phong .8
        phong_size 50
        reflection {0.35, 1 fresnel}
        conserve_energy
     } 
     
     
     normal { 
        pigment_pattern{ 
            spotted 
            colour_map {
			[0.00 color  rgb 0]  
			[0.40 color  rgb 0]
			[0.42 color  rgb 1] 
			[0.78 color  rgb 1]
			[0.80 color  rgb 0]
			[1.00 color  rgb 0]
            } 
         }   
        scale sz 
        warp { turbulence turb }
        bump_size bump
    }
} 

 
#declare T_teal_cutout2 =  

#declare sz = .2;   
#declare turb = 0.05; 
#declare bump = 1;  //over the top
    texture {
        pigment {  
           spotted
           color_map{
			[0.00 color  C_clear ]  
			[0.40 color  C_clear ]
			[0.40 color  C_gray_teal_dark ]
			[0.44 color  C_gray_teal ]
			[0.76 color  C_gray_teal ] 
			[0.80 color  C_gray_teal_dark ]
			[0.80 color  C_clear ]
			[1.00 color  C_clear ]
             } 
        scale sz
        warp { turbulence turb }
        
        }
     
     
     
     finish{
        ambient .2
        diffuse .9
        phong .8
        phong_size 50
        //reflection {0.35, 1 fresnel}
        //conserve_energy
     } 
     
     
     normal { 
        pigment_pattern{ 
            spotted 
            colour_map {
			[0.00 color  rgb 0]
			
			[0.20 color  rgb 0]
			[0.22 color  rgb 1]
			[0.22 color  rgb 1]
			[0.20 color  rgb .8]
			
			
			
			[0.40 color  rgb .8]
			[0.42 color  rgb 1] 
			[0.78 color  rgb 1]
			[0.80 color  rgb 0]
			[1.00 color  rgb 0]
            } 
         }   
        scale sz 
        warp { turbulence turb }
        bump_size bump
    }
} 


#declare M_rust_paint =
material{ 
    texture{ T_rust             scale .5  }
    texture{ T_teal_cutout      scale 1.0  } 
    //texture{ T_teal_cutout      scale 2  }
}    
 
 
 
 
#declare M_rust_brush =
material{ 
    texture{ T_rust_brush        scale 1.0  }
    texture{ T_teal_cutout2      scale 1.0  } 
}    
 


#declare M_rust_dent =
material{ 
    texture{ T_rust              scale 1.0  }
    texture{ T_teal_cutout2      scale 1.0  } 
    texture{ T_rust_dent         scale 1.0  }
} 
 
 
 
 
 
 
 
 
 
//------------------------------------------------------------------------------------------------------------------------------------
//                                                   TOPO
//------------------------------------------------------------------------------------------------------------------------------------





#declare C_map_blob_grain =  
        color_map {
            [0.00    C_seabottom_gold]
            [0.1    C_seabottom_teal]
            [0.3    C_seabottom_sage]
            [0.5    C_seabottom_gold*2]
            [0.7    C_seabottom_teal]
            [0.8    C_seabottom_sage]
            [1.01    C_seabottom_gold]
        }

#declare C_map_blob_hill = 
        color_map {
            [0.000 rgbf <0.625, 0.659, 0.355, 0>]
            [0.171 rgbf <0.582, 0.449, 0.220, 0>]
            [0.274 rgbf <0.357, 0.351, 0.022, 1>]
            [0.393 rgbf <0.625, 0.619, 0.355, 1>]
            [0.564 rgbf <0.582, 0.519, 0.320, 1>]
            [0.701 rgbf <0.482, 0.392, 0.178, 1>]
            [1.000 rgbf <0.625, 0.659, 0.255, 0>]
        }
        




#declare T_crackle_A = 
    texture{
        pigment{ 
            granite         
            scale 1 
            turbulence .3
            color_map{C_map_blob_grain} 
        } 
      
        normal { 
            granite
            scale 1 
            turbulence 0.01
            bump_size .8
    
       } 
           finish { 
            ambient .2 
            diffuse 1 
            phong .7     
            phong_size 80 
            reflection .1
           }
    } 
    
    
    
     
    
#declare T_crackle_B = 
    texture{
        pigment{ 
            agate
            scale .8 
            turbulence 0.005
            color_map{C_map_blob_hill} 
        } 
      
        normal { 
            agate
            scale .8 
            turbulence 0.005
            bump_size .8
    
       } 
           finish { 
            ambient .2 
            diffuse 1 
            phong .8     
            phong_size 80
            reflection .05 
           }
      
      rotate<0,0,0>
      translate<0,0,0>
    }    
        
#declare M_topo_crackle = 
material{ 
   texture { T_crackle_A  scale 2 translate y-1}
   texture { T_crackle_B scale .6}
} 



#declare M_topo_crackle = 
material{ 
   texture { T_crackle_A  scale 2 translate y-1}
   texture { T_crackle_B scale .6}
}
    
    
#declare M_topo_crackle_B = 
material{
    texture {
      bozo   
      texture_map { 
      
       [0 T_crackle_A ]
       [.40 T_crackle_A ] 
       [.52 T_crackle_B ] 
       [.72 T_crackle_B ]
       [1 T_crackle_A ]
      }
      warp {
        turbulence 2
      }  
      
     
    } 

}          
  
   
#declare N_crackle_A =
normal { 
    pigment_pattern{ 
        crackle 
        turbulence 0.2
        colour_map {[0.00, rgb 0]
                    [0.25, rgb 1]
                    [0.95, rgb 1]
                    [1.00, rgb 0]
                    } 
     }
}    








        
#declare C_map_ground =  
        color_map {
            [0.00       C_ground_gray_brown]
            [0.1        C_ground_gray_green]
            [0.3        C_ground_gray_brown]
            [0.5        C_ground_gray_sage]
            [0.7        C_ground_gray_green]
            [1.01       C_ground_gray_brown]
        }


#declare C_map_ground_green =  
        color_map {
            [0.00       C_ground_gray_green]
            [0.1        C_ground_gray_brown]
            [0.3        C_ground_gray_dark]
            [0.5        C_ground_gray_sage]
            [0.7        C_ground_gray_green]
            [1.01       C_ground_gray_dark]
        }
        

//------ ground
#declare T_ground_tan = 
#declare sz = 2;   
#declare turb = 0.2; 
#declare bump = 2;  //over the top
texture{
    pigment{ 
        crackle  
        turbulence turb
        color_map{ C_map_ground }
        scale sz
        } 
             
    normal { 
        pigment_pattern{ 
            crackle 
            turbulence turb
            colour_map {[0.00, rgb 0]
                        [0.25, rgb 1]
                        [0.95, rgb 1]
                        [1.00, rgb 0]
                        } 
         }
         scale sz 
         bump_size bump 
    }   
        
    finish { 
        ambient .2
        diffuse .8 
        phong .7
        phong_size 30  
        reflection .02
        }
}

//------ ground
#declare T_ground_green = 
#declare sz = 10;   
#declare turb = 0.02; 
#declare bump = 1;  //over the top
texture{
    pigment{ 
        granite  
        turbulence turb
        color_map{ C_map_ground_green }
        scale sz
        } 
             
    normal { 
        pigment_pattern{ 
            granite 
            turbulence turb
            colour_map {[0.00, rgb 0]
                        [0.25, rgb 1]
                        [0.75, rgb 1]
                        [1.00, rgb 0]
                        } 
         }
         scale sz 
         bump_size bump 
    }   
        
    finish { 
        ambient .2
        diffuse .8 
        phong .7
        phong_size 30  
        reflection .02
        }
}



//--- ground crack
#declare T_ground_crack = 
#declare sz = .5;   
#declare turb = .25;
#declare bump = 5;  //over the top
texture{
    pigment{ 
        crackle  
        turbulence turb
        color_map{ 
            [0.03 color C_black transmit .15] 
            [0.10 color C_black transmit .6]  
            [0.30 color C_seabottom_teal transmit .7] 
            [0.50 color Transparent] 
            [1.00 color C_gold transmit .6]
            } 
        }    
    normal { 
        pigment_pattern{ 
            crackle 
            turbulence turb
            colour_map {[0.00, rgb 0]
                        [0.25, rgb 1]
                        [0.95, rgb 1]
                        [1.00, rgb 0]
                        } 
         } 
            scale sz 
            bump_size bump
    }


    finish {  
        phong .5
        phong_size 30
        ambient .2
        diffuse .8
        }    
    
}
 
 
 
                 

    
//--- ground crack
#declare T_ground_crack_B = 
#declare sz = .5;   
#declare turb = .65;
texture{
    pigment{ 
        crackle  
        turbulence turb
        color_map{ 
            [0.03 color C_black transmit .15] 
            [0.10 color C_black transmit .6]  
            [0.30 color C_seabottom_teal transmit .7] 
            [0.50 color Transparent] 
            [1.00 color C_gold transmit .6]
            } 
        }    
    normal { 
        marble  
        turbulence turb
        bump_size 10 
        }
    finish {  
        phong .5
        phong_size 30
        ambient .2
        diffuse .8
        }    
    
}


//------ ground
#declare M_ground_A = 
material {
    texture {T_ground_tan       scale 1}
} 

//------ ground
#declare M_ground_B = 
material {
    texture {T_ground_green     scale 3}
} 

#declare C_map_spotted_A =  
        color_map {
            [0.00       C_ground_gray_cool * 3]
            [0.1        C_ground_gray_green * 1.5]
            [0.3        C_ground_gray_brown *1.3]
            [0.7        C_ground_gray_gold]
            [0.85        C_ground_gray_cream ]
            [1.01       C_ground_gray_cream]
        }
        
       
         
//------ spotted mushroom
#declare T_spotted_shroom = 
#declare sz = 2;   
#declare turb = 0.12; 
#declare bump = 5;  //over the top
texture{
    pigment{ 
        leopard  
        turbulence turb
        color_map{ C_map_spotted_A }
        scale sz
        } 
             
    normal { 
        pigment_pattern{ 
            leopard 
            turbulence turb
            colour_map {[0.00, rgb 0]
                        [0.1, rgb .2]
                        [0.4,  rgb 1]
                        [0.5,  rgb 1]
                        //[0.8,  rgb .2]
                        [1.00, rgb 1]
                        } 
         }
         scale sz 
         bump_size bump 
    }   
        
    finish { 
        ambient .2
        diffuse .8 
        phong .7
        phong_size 40  
        reflection .05
        }
} 

#declare M_spotted_shroom = material {texture{T_spotted_shroom}}

   
#declare M_satin_gray = 
material{
    texture{
        pigment{ 
            color  C_gray50
        } 
           finish { 
            ambient .2 
            diffuse 1 
            phong .5     
            phong_size 50
            reflection .05 
           }
    } 
}    

#declare C_gold_black =       color rgb<.1,.15,.2>   ; 

#declare C_map_spotted_weed =  
        color_map {
            [0.00       C_gold_black*.1] 
            [0.4        C_gold_black*1.5]
            [0.8        C_seabottom_teal *.6]
            [1.1        C_gold_black*.1]

        }

//------ spotted mushroom
#declare T_spotted_weed = 
#declare sz = 2;   
#declare turb = 0.02; 
#declare bump = 5;  //over the top
texture{
    pigment{ 
        leopard  
        turbulence turb
        color_map{ C_map_spotted_weed }
        scale sz
        } 
             
    normal { 
        pigment_pattern{ 
            leopard 
            turbulence turb
            colour_map {
                        [0.00, rgb 0]
                        [0.2,  rgb 0]  
                        [0.5,  rgb 1] 
                        [0.7,  rgb 1]
                        [1.00, rgb 0]
                        } 
         }
         scale sz 
         bump_size bump 
    }   
        
    finish { 
        ambient .2
        diffuse 1 
        phong .6
        phong_size 50  
        reflection .05
        }
} 

#declare M_spotted_weed = material {texture{T_spotted_weed}}  



#declare C_med_teal = rgb <0.05, 0.4, 0.1> * 2; 
#declare C_dark_green = rgb <0.10, 0.77, 0.48> ;
#declare C_clear = colour red 0.0 green 0.0 blue 0.0 transmit 1 ;
 

#declare C_green_bud =
    color_map {
        [ 0.0     C_dark_green ]  
        [ 0.2     C_med_teal ]
        [ 0.4     C_med_teal ]
        [ 1.0     C_dark_green ]
        }

#declare N_bud = normal { 
    bumps 1 
    scale 1 turbulence 0.05 bump_size 1 }   ;     


#declare bud_material =
material {
    texture {
        pigment {
            gradient y
            color_map {C_green_bud}
            translate y-.7
            }
        finish { 
            diffuse 1
            phong 4
            phong_size 60  
            emission 1.5
            } 
        normal {N_bud scale .1}    
    }
}
