//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Contains 2 lights, 103 materials and 72 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.5 For Windows Copyright (c) 1993-2003 Lutz + Kretzschmar
//

//  Date : 02/28/2009    (28.02.2009)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.4 Beta For Windows.
Comment merged from cessna.mdl:
This scene was created with Moray V3.5 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset ascii
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <      4.202,      13.934,       1.991>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.31242,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         29.90723    // Vertical      23.006
  look_at   <      0.033,       4.213,      -0.606>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.9998
  photons {
  }
  translate  <-5.945813, 9.96681, 5.668304>
}

light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.9998
  fade_distance  100.0
  fade_power 1.0
  media_attenuation on
  translate  <6.532176, 10.452109, 6.34092>
}


//
// ********  MATERIALS  *******
//

#include "f105.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-1.093775, 0.133541>,
  <-0.847066, 0.139408>,
  <-0.736266, 0.198892>,
  <-0.61123, 0.353902>,
  <-0.60202, 0.511859>,
  <-0.719342, 0.359624>,
  <-0.84123, 0.29615>,
  <-1.084565, 0.291498>,
  <-1.093775, 0.133541>
  rotate -x*90
  material {
    T_Chrome_1C
  }
  scale <1.021477, 1.0, 0.136841>
  rotate <90.0, -90.0, 0.0>
  translate  <2.997307, -1.395092, 1.833238>
}
#declare RightMainGearDoor = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  15  // control points
  <0.730353, -1.598124>,
  <0.733001, -1.863504>,
  <0.880563, -1.863018>,
  <0.999651, -1.825948>,
  <1.101332, -1.727215>,
  <1.217159, -1.661491>,
  <1.30764, -1.598124>,
  <3.314986, -1.598124>,
  <3.314986, -1.284565>,
  <1.315009, -1.284565>,
  <1.197118, -1.218252>,
  <1.042386, -1.115097>,
  <0.898246, -1.043718>,
  <0.733577, -1.043718>,
  <0.730353, -1.598124>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <0.951406, 1.004716, 0.1>
  rotate -90.0*y
  translate  <2.919625, 0.011221, 0.116038>
}
#declare RightMainLandingGear = union {
  cylinder { // RightLandingGearMainStrut
    <0,0,1>, <0,0,0>, 1 
    material {
      texture { white_txt }
    }
    scale <0.071968, 0.089858, 1.521067>
    translate  <2.55582, -1.464424, 1.818676>
  }
  torus { // RightMainWheelTire
    1.5, 0.5  rotate -x*90
    material {
      black_txt
    }
    scale 0.193015
    rotate <-90.0, 0.0, -90.0>
    translate  <2.54366, -1.449549, 0.70204>
  }
  cylinder { // RightLandingGearOleo
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome1
    }
    scale <0.056685, 0.070413, 0.862537>
    translate  <2.55582, -1.464424, 1.183172>
  }
  object { TransSweep001 }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_4E
    }
    scale <0.272393, 0.276214, 0.146308>
    rotate -90.0*y
    translate  <2.614464, -1.444517, 0.715526>
  }
  object { RightMainGearDoor }
  translate  <-0.787231, 0.089969, 0.0>
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-1.093775, 0.133541>,
  <-0.847066, 0.139408>,
  <-0.736266, 0.198892>,
  <-0.61123, 0.353902>,
  <-0.60202, 0.511859>,
  <-0.719342, 0.359624>,
  <-0.84123, 0.29615>,
  <-1.084565, 0.291498>,
  <-1.093775, 0.133541>
  rotate -x*90
  material {
    T_Chrome_1C
  }
  scale <1.021477, 1.0, 0.136841>
  rotate <90.0, -90.0, 0.0>
  translate  <2.997307, -1.395092, 1.833238>
}
#declare RightMainGearDoor1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  15  // control points
  <0.730353, -1.598124>,
  <0.733001, -1.863504>,
  <0.880563, -1.863018>,
  <0.999651, -1.825948>,
  <1.101332, -1.727215>,
  <1.217159, -1.661491>,
  <1.30764, -1.598124>,
  <3.314986, -1.598124>,
  <3.314986, -1.284565>,
  <1.315009, -1.284565>,
  <1.197118, -1.218252>,
  <1.042386, -1.115097>,
  <0.898246, -1.043718>,
  <0.733577, -1.043718>,
  <0.730353, -1.598124>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <0.951406, 1.004716, 0.1>
  rotate -90.0*y
  translate  <2.919625, 0.011221, 0.116038>
}
#declare LeftMainLandingGear = union {
  cylinder { // RightLandingGearMainStrut1
    <0,0,1>, <0,0,0>, 1 
    material {
      texture { white_txt }
    }
    scale <0.071968, 0.089858, 1.521067>
    translate  <2.55582, -1.464424, 1.818676>
  }
  torus { // RightMainWheelTire1
    1.5, 0.5  rotate -x*90
    material {
      black_txt
    }
    scale 0.193015
    rotate <-90.0, 0.0, -90.0>
    translate  <2.54366, -1.449549, 0.70204>
  }
  cylinder { // RightLandingGearOleo1
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome1
    }
    scale <0.056685, 0.070413, 0.862537>
    translate  <2.55582, -1.464424, 1.183172>
  }
  object { TransSweep002 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_4E
    }
    scale <0.272393, 0.276214, 0.146308>
    rotate -90.0*y
    translate  <2.614464, -1.444517, 0.715526>
  }
  object { RightMainGearDoor1 }
  rotate 180.0*z
  translate  <0.063874, -2.9573, -0.012669>
}
#declare C2MainLandingGears = union {
  object { RightMainLandingGear }
  object { LeftMainLandingGear }
}
#declare NoseGearFork = difference {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 open
    material {
      Aluminum
    }
    scale <0.497165, 0.529992, 0.154415>
    rotate 90.0*x
    translate  <-2.180987, 4.63152, 4.073711>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    scale <0.661133, 0.190784, 0.33684>
    translate  <-2.15266, 4.528831, 3.658207>
  }
  material {
    gray90_txt
  }
  scale <0.256727, 0.734047, 1.036201>
  rotate -0.570374*x
  translate  <0.199891, 0.584837, -3.481054>
}
#declare NoseGearSissors = difference {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 open
    material {
      Aluminum
    }
    scale <0.497165, 0.529992, 0.154415>
    rotate 90.0*x
    translate  <-2.180987, 4.63152, 4.073711>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    scale <0.661133, 0.190784, 0.33684>
    translate  <-2.15266, 4.528831, 3.658207>
  }
  material {
    gray90_txt
  }
  scale <0.240297, 0.734047, 0.545675>
  rotate <90.0, -90.0, 0.0>
  translate  <2.997001, 6.091551, 2.097262>
}
#declare RightNoseGearOutterDoor = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.965462, -1.0>,
  <1.034538, -1.0>,
  <1.034538, -0.511051>,
  <-0.951071, -0.712524>,
  <-0.965462, -1.0>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <1.04664, 1.0, 0.048543>
  rotate <-90.0, 0.0, -90.0>
  translate  <-0.012539, 4.909571, 1.395439>
}
#declare LeftNoseGearOutterDoor = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.965462, -1.0>,
  <1.034538, -1.0>,
  <1.034538, -0.511051>,
  <-0.951071, -0.712524>,
  <-0.965462, -1.0>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <1.04664, 1.0, 0.048543>
  rotate <-90.0, 0.0, -90.0>
  translate  <-0.815042, 4.909571, 1.373661>
}
#declare NoseWheelAssembly = union {
  cylinder { // NoseWheelWheel
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome1
    }
    scale <0.165324, 0.185435, 0.1122>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.452093, 3.992684, 0.671489>
  }
  cylinder { // NoseGearStrutFixture
    <0,0,1>, <0,0,0>, 1 
    material {
      texture { white_txt }
    }
    scale <0.14, 0.14, 0.9>
    translate  <-0.354571, 3.971905, 1.5764>
  }
  cylinder { // NoseGearStrut
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_5D
    }
    scale <0.07, 0.07, 1.11025>
    translate  <-0.360688, 3.971905, 1.205594>
  }
  torus { // NoseWheelTire
    1.5, 0.5  rotate -x*90
    material {
      black_txt
    }
    // All transformations fixed
    scale 0.164234
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.363003, 3.968212, 0.654958>
  }
  object { NoseGearFork }
  object { NoseGearSissors }
  cone { // RightLandingLight
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      ChromeTexture1
    }
    scale <0.153648, 0.117579, 0.303477>
    rotate -90.0*x
    translate  <-0.112371, 3.963785, 1.683075>
  }
  cone { // LeftLandingLight
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      ChromeTexture1
    }
    scale <0.153648, 0.117579, 0.303477>
    rotate -90.0*x
    translate  <-0.614632, 3.963785, 1.695178>
  }
  cylinder { // GroundRadarReflector
    <0,0,1>, <0,0,0>, 1 
    material {
      yellow100_txt
    }
    scale <0.147022, 0.110948, 0.172281>
    rotate -90.0*x
    translate  <-0.348048, 4.101257, 1.864372>
  }
  object { RightNoseGearOutterDoor }
  object { LeftNoseGearOutterDoor }
}
#declare LandingGear = union {
  object { C2MainLandingGears }
  object { NoseWheelAssembly }
}
#declare LeftWingBottom = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  15  // control points
  <1.738494, -4.496489>,
  <2.440641, -4.506709>,
  <2.46108, -0.830741>,
  <2.333283, -0.820826>,
  <1.669728, 0.556284>,
  <1.589988, 0.352491>,
  <1.51381, -0.134607>,
  <1.37047, -1.504816>,
  <-1.612316, -4.842097>,
  <-1.71989, -5.008845>,
  <-1.774864, -5.182679>,
  <-1.792936, -5.354428>,
  <-1.765481, -5.852734>,
  <-1.539269, -6.609473>,
  <1.738494, -4.496489>
  rotate -x*90
  material {
    Aluminum
  }
  scale <-1.0, -1.0, -0.027087>
  rotate -180.0*z
  translate  <-3.25186, 1.527179, 3.386449>
}
#declare RightWingBottom = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  15  // control points
  <1.539269, -6.609473>,
  <1.765481, -5.852734>,
  <1.792936, -5.354428>,
  <1.774864, -5.182679>,
  <1.71989, -5.008845>,
  <1.612316, -4.842097>,
  <-1.37047, -1.504816>,
  <-1.51381, -0.134607>,
  <-1.589988, 0.352491>,
  <-1.669728, 0.556284>,
  <-2.333283, -0.820826>,
  <-2.46108, -0.830741>,
  <-2.440641, -4.506709>,
  <-1.738494, -4.496489>,
  <1.539269, -6.609473>
  rotate -x*90
  material {
    Aluminum
  }
  scale <1.0, 1.054194, 0.00001>
  translate  <2.683454, 1.760275, 3.370925>
}
#declare RightPylon = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.040956, -2.1405>,
  <-2.981139, -2.866862>,
  <-2.927639, -2.156294>,
  <-2.956831, -1.451662>,
  <-3.040956, -2.1405>
  rotate -x*90
  material {
    dkgreen_txt
  }
  translate  <5.444335, -0.335468, 2.349958>
}
#declare LeftPylon = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.040956, -2.1405>,
  <-2.981139, -2.866862>,
  <-2.927639, -2.156294>,
  <-2.956831, -1.451662>,
  <-3.040956, -2.1405>
  rotate -x*90
  material {
    dkgreen_txt
  }
  translate  <-0.157718, -0.341363, 2.36043>
}
#declare WingsGroup = union {
  object { LeftWingBottom }
  object { RightWingBottom }
  object { RightPylon }
  object { LeftPylon }
  material {
    dkgreen_txt
  }
}
#declare LeftStablizer = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.65724, -0.723972>,
  <-0.656332, -1.103615>,
  <-0.588783, -1.355582>,
  <1.151664, -0.47221>,
  <1.057632, 1.080898>,
  <-0.590508, -0.501472>,
  <-0.65724, -0.723972>
  rotate -x*90
  material {
    Aluminum
  }
  scale <1.064362, 1.041095, 0.1>
  translate  <-2.066921, -7.073915, 2.6757>
}
#declare RightStablizer = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <0.590508, -0.501472>,
  <-1.057632, 1.080898>,
  <-1.151664, -0.47221>,
  <0.588783, -1.355582>,
  <0.656332, -1.103615>,
  <0.65724, -0.723972>,
  <0.590508, -0.501472>
  rotate -x*90
  material {
    Aluminum
  }
  scale <1.0, 1.0, 0.1>
  translate  <1.502002, -7.125284, 2.6757>
}
#declare StabGroup = union {
  object { LeftStablizer }
  object { RightStablizer }
  material {
    dkgreen_txt
  }
}
#declare RearCanopyFairing = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.401333, -0.476803, 0.223235>, <-0.315066, -1.504133, 0.009653>, <0.148284, -1.493658, 0.004826>, <0.295169, -0.477257, 0.220822>, 
      <-0.270423, -0.546564, 2.009452>, <-0.226698, -1.496846, 1.962293>, <0.107515, -1.493658, 1.939669>, <0.176746, -0.550662, 1.986828>, 
      <-0.156812, -0.616510, 4.041956>, <-0.167743, -1.504133, 4.000000>, <0.022963, -1.500945, 4.000000>, <0.055757, -0.620607, 4.041956>, 
      <-0.045111, -0.839003, 5.961603>, <-0.098747, -1.504133, 5.976433>, <0.034747, -1.500945, 5.964650>, <0.016237, -0.836104, 5.949820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.295169, -0.477257, 0.220822>, <0.442053, 0.539143, 0.436817>, <-0.487600, 0.550527, 0.436817>, <-0.401333, -0.476803, 0.223235>, 
      <0.176746, -0.550662, 1.986828>, <0.245977, 0.392333, 2.033987>, <-0.314148, 0.403717, 2.056611>, <-0.270423, -0.546564, 2.009452>, 
      <0.055757, -0.620607, 4.041956>, <0.088551, 0.259730, 4.083911>, <-0.145881, 0.271114, 4.083911>, <-0.156812, -0.616510, 4.041956>, 
      <0.016237, -0.836104, 5.949820>, <-0.002274, -0.171263, 5.934989>, <0.008525, -0.173872, 5.946773>, <-0.045111, -0.839003, 5.961603>
    }
  }
  material {
    dkgreen_txt
  }
  rotate 90.0*x
  translate  <-0.352529, 2.97616, 4.054271>
}
#declare FuselageNearTheEngine = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.633366, 0.074420, -0.029195>, <-0.632858, -1.147580, -0.029607>, <0.602822, -1.153428, -0.023953>, <0.602240, 0.077756, -0.024234>, 
      <-0.630690, 0.186033, 2.097899>, <-0.615120, -1.058711, 2.002179>, <0.762820, -1.001808, 2.035119>, <0.732696, 0.169084, 2.119045>, 
      <-1.014627, 0.017039, 6.114924>, <-1.029254, -1.343141, 6.225271>, <1.076061, -1.343141, 6.207718>, <1.028311, 0.016720, 6.106709>, 
      <-0.413447, 0.052200, 7.716079>, <-0.413447, -0.444177, 7.728395>, <0.477009, -0.441126, 7.728395>, <0.477009, 0.055252, 7.716079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.602240, 0.077756, -0.024234>, <0.601659, 1.308941, -0.024515>, <-0.633874, 1.296419, -0.028784>, <-0.633366, 0.074420, -0.029195>, 
      <0.732696, 0.169084, 2.119045>, <0.702571, 1.339977, 2.202972>, <-0.646259, 1.430777, 2.193619>, <-0.630690, 0.186033, 2.097899>, 
      <1.028311, 0.016720, 6.106709>, <0.980560, 1.376581, 6.005700>, <-1.000000, 1.377219, 6.004577>, <-1.014627, 0.017039, 6.114924>, 
      <0.477009, 0.055252, 7.716079>, <0.477009, 0.551630, 7.703763>, <-0.413447, 0.548576, 7.703763>, <-0.413447, 0.052200, 7.716079>
    }
  }
  material {
    dkgreen_txt
  }
  rotate 90.0*x
  translate  <-0.350795, -1.227208, 3.056004>
}
#declare FuselageNextToNoseCone = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.022278, -0.349638, -0.749288>, <-1.063074, -1.728247, -0.746261>, <1.161497, -1.728691, -0.747434>, <1.161491, -0.340339, -0.757604>, 
      <-0.991332, -0.330566, 1.754536>, <-1.061125, -1.643031, 1.129307>, <1.156923, -1.643031, 1.107965>, <1.200513, -0.330565, 1.733194>, 
      <-0.571125, -0.082315, 4.171302>, <-0.505790, -1.062861, 4.707870>, <0.764615, -1.062861, 4.724469>, <1.000000, -0.082314, 4.259039>, 
      <-0.234284, -0.072119, 6.038003>, <-0.229337, -0.464275, 6.070118>, <0.418912, -0.461727, 6.067399>, <0.418621, -0.056278, 6.034888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.161491, -0.340339, -0.757604>, <1.161485, 1.048013, -0.767774>, <-0.981482, 1.028972, -0.752315>, <-1.022278, -0.349638, -0.749288>, 
      <1.200513, -0.330565, 1.733194>, <1.244103, 0.981901, 2.358423>, <-0.921538, 0.981898, 2.379764>, <-0.991332, -0.330566, 1.754536>, 
      <1.000000, -0.082314, 4.259039>, <1.235385, 0.898234, 3.793610>, <-0.636461, 0.898231, 3.634734>, <-0.571125, -0.082315, 4.171302>, 
      <0.418621, -0.056278, 6.034888>, <0.418329, 0.349172, 6.002378>, <-0.239231, 0.320036, 6.005889>, <-0.234284, -0.072119, 6.038003>
    }
  }
  material {
    dkgreen_txt
  }
  scale <0.640341, 0.657972, 0.470839>
  rotate -90.0*x
  translate  <-0.41493, 5.149785, 2.73283>
}
#declare VentralFin = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <-1.491997, -6.711972>,
  <-1.218912, -7.276097>,
  <-1.449167, -3.906078>,
  <-1.607124, -3.963642>,
  <-1.747761, -4.121617>,
  <-1.871071, -4.395372>,
  <-1.957856, -4.635953>,
  <-1.991751, -4.880106>,
  <-1.919263, -5.270915>,
  <-1.816128, -5.614871>,
  <-1.658738, -6.120145>,
  <-1.491997, -6.711972>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <0.83516, 0.953775, 0.1>
  rotate -90.0*y
  translate  <-0.297481, -0.276306, 3.441558>
}
#declare CenterPylon = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-3.040956, -2.1405>,
  <-2.981139, -2.866862>,
  <-2.927639, -2.156294>,
  <-2.956831, -1.451662>,
  <-3.040956, -2.1405>
  rotate -x*90
  material {
    dkgreen_txt
  }
  translate  <2.640934, 1.850064, 1.822313>
}
#declare FuselageGroup = union {
  object { RearCanopyFairing }
  object { FuselageNearTheEngine }
  object { FuselageNextToNoseCone }
  cone { // NoseCone
    <0,0,0>, 0.0, <0,0,1>, 1.001
    open
    material {
      dkgreen_txt
    }
    scale <0.208089, 0.2, 0.585529>
    rotate 86.0*x
    translate  <-0.351223, 8.573243, 2.731341>
  }
  object { VentralFin }
  object { CenterPylon }
  material {
    dkgreen_txt
  }
}
#declare CanopyBow = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 open
    material {
      Aluminum
    }
    scale <0.497165, 0.529992, 0.154415>
    rotate 90.0*x
    translate  <-2.180987, 4.63152, 4.073711>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    scale <0.661133, 0.190784, 0.33684>
    translate  <-2.15266, 4.528831, 3.658207>
  }
  scale <0.803357, 0.735509, 1.036363>
  rotate -12.0*x
  translate  <1.384936, -0.587726, 0.215303>
}
#declare BulletProofGlassFrame = difference {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 open
    material {
      Aluminum
    }
    scale <0.497165, 0.529992, 0.154415>
    rotate 90.0*x
    translate  <-2.180987, 4.63152, 4.073711>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    scale <0.661133, 0.190784, 0.33684>
    translate  <-2.15266, 4.528831, 3.658207>
  }
  material {
    Aluminum
  }
  // All transformations fixed
  scale <0.416508, 0.533186, 1.9723>
  rotate 60.0*x
  translate  <0.522047, 10.287568, -2.492767>
}
#declare LeftFrontCanopy = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.629996, -2.241127, -0.576832>, <0.624194, -2.132222, -0.351046>, <0.691493, -2.049052, -0.069430>, <0.941389, -2.079338, -0.028399>, 
      <0.620712, -1.893146, -0.565557>, <0.633761, -1.882688, -0.374169>, <0.731437, -1.881617, -0.201708>, <0.841991, -1.905011, -0.070320>, 
      <0.601994, -1.407213, -0.554049>, <0.636028, -1.221297, -0.454502>, <0.707999, -1.253745, -0.285289>, <0.764845, -1.233227, -0.170383>, 
      <0.607891, -0.896159, -0.556175>, <0.631390, -0.469639, -0.569343>, <0.686789, -0.173094, -0.597592>, <0.788055, 0.168894, -0.649474>
    }
  }
  material {
    Plexiglas
  }
  scale <1.095867, 0.427797, 1.0>
  translate  <-1.453099, 4.58393, 4.172425>
}
#declare RightFrontCanopy = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.613092, -2.240784, -0.599509>, <-0.607402, -2.148733, -0.352229>, <-0.682397, -2.034463, -0.106144>, <-0.941389, -2.079338, -0.028399>, 
      <-0.612475, -1.864728, -0.600988>, <-0.618895, -1.895381, -0.374169>, <-0.715536, -1.905591, -0.198578>, <-0.841991, -1.905011, -0.070320>, 
      <-0.601432, -1.393425, -0.601869>, <-0.627099, -1.244857, -0.441725>, <-0.707999, -1.253745, -0.285289>, <-0.764845, -1.233227, -0.170383>, 
      <-0.611259, -0.891804, -0.609449>, <-0.636389, -0.467442, -0.624460>, <-0.690011, -0.185992, -0.648273>, <-0.788055, 0.157362, -0.672906>
    }
  }
  material {
    Plexiglas
  }
  scale <1.095867, 0.427797, 1.0>
  translate  <0.699228, 4.584837, 4.198857>
}
#declare CenterCanopy = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.014826, -1.012973>,
  <-0.906344, -0.885901>,
  <-0.837679, -0.570114>,
  <-0.819206, 0.05217>,
  <-1.210525, 0.055113>,
  <-1.200645, -0.548764>,
  <-1.126232, -0.873546>,
  <-1.014826, -1.012973>
  rotate -x*90
  material {
    Plexiglas
  }
  scale <1.0, 1.0, 0.1>
  rotate -30.0*x
  translate  <0.634141, 4.536266, 3.576453>
}
#declare CanopyGroup = union {
  object { CanopyBow }
  object { BulletProofGlassFrame }
  object { LeftFrontCanopy }
  object { RightFrontCanopy }
  object { CenterCanopy }
  material {
    dkgreen_txt
  }
  // All transformations fixed
}
#declare RudderFinAndRudder = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <3.199802, -2.045876>,
  <3.226699, -1.680382>,
  <3.214535, -1.341819>,
  <1.180687, 0.78024>,
  <0.982624, 1.366706>,
  <0.460897, 1.949335>,
  <0.30523, 1.951419>,
  <-0.046169, 1.931174>,
  <0.072656, -1.585223>,
  <0.29116, -1.157894>,
  <0.430022, -1.048389>,
  <3.092166, -2.24518>,
  <3.199802, -2.045876>
  rotate -x*90
  material {
    dkgreen_txt
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.1>
  rotate -90.0*y
  translate  <-0.244874, -6.540887, 3.645925>
}
#declare FuselageUnderCockpit = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.603221, -0.032030, -0.011301>, <-0.578536, -0.937902, -0.007589>, <0.804612, -0.951374, -0.004150>, <0.795019, -0.036770, -0.006174>, 
      <-0.510118, 0.081606, 1.688161>, <-0.510118, -0.990964, 1.704125>, <0.769558, -0.981033, 1.696979>, <0.769558, 0.091540, 1.681015>, 
      <-0.486895, 0.100863, 4.018056>, <-0.486895, -1.070350, 4.036113>, <0.693637, -1.060419, 4.022715>, <0.693637, 0.110796, 4.004658>, 
      <-0.518378, 0.133336, 5.983691>, <-0.519646, -1.093601, 5.983259>, <0.715967, -1.083669, 5.988221>, <0.717235, 0.143269, 5.988653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.795019, -0.036770, -0.006174>, <0.785427, 0.877835, -0.008197>, <-0.627905, 0.873842, -0.015012>, <-0.603221, -0.032030, -0.011301>, 
      <0.769558, 0.091540, 1.681015>, <0.769558, 1.164112, 1.665052>, <-0.510118, 1.154177, 1.672197>, <-0.510118, 0.081606, 1.688161>, 
      <0.693637, 0.110796, 4.004658>, <0.693637, 1.282010, 3.986602>, <-0.486895, 1.272076, 4.000000>, <-0.486895, 0.100863, 4.018056>, 
      <0.717235, 0.143269, 5.988653>, <0.718502, 1.370207, 5.989086>, <-0.517110, 1.360273, 5.984124>, <-0.518378, 0.133336, 5.983691>
    }
  }
  material {
    dkgreen_txt
  }
  rotate 90.0*x
  translate  <-0.25394, 5.127041, -0.719404>
}
#declare FuselageWithACutOutInIt = difference {
  object { FuselageUnderCockpit }
  sphere { // FrontCanopyCuttout
    <0,0,0>,1
    material {
      Plexiglas
    }
    scale <-0.179968, -0.624439, -0.179264>
    rotate 180.0*x
    translate  <-0.181205, 3.999591, -0.029818>
  }
  box { // RearCanopyCuttout
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    scale <0.270477, 0.589923, 0.735341>
    translate  <-0.187491, 3.424802, -0.560483>
  }
  translate  <-0.211844, -0.341363, 3.713583>
}
#declare RemovableCanopy = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.863773, -2.909505, -0.674529>, <-0.830967, -3.286549, -0.212001>, <-0.491431, -3.384518, -0.073720>, <-0.199605, -3.417766, -0.078702>, 
      <-0.895378, -2.035380, -0.697702>, <-1.091878, -2.288076, -0.186948>, <-0.562637, -2.352123, 0.006347>, <-0.215560, -2.351526, -0.006202>, 
      <-0.916403, -1.173468, -0.711517>, <-1.095732, -1.275141, -0.195350>, <-0.532782, -1.237877, 0.002457>, <-0.200632, -1.187197, -0.000653>, 
      <-0.913489, -0.943502, -0.713560>, <-1.072392, -1.079722, -0.199637>, <-0.526020, -0.946580, -0.012840>, <-0.197251, -0.907795, -0.015558>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.913489, -0.943502, -0.713560>, <-1.072392, -1.079722, -0.199637>, <-0.526020, -0.946580, -0.012840>, <-0.197251, -0.907795, -0.015558>, 
      <-0.910574, -0.713537, -0.715604>, <-1.049051, -0.884304, -0.203924>, <-0.519258, -0.655283, -0.028138>, <-0.193871, -0.628393, -0.030464>, 
      <-0.906025, -0.097833, -0.728773>, <-0.945857, 0.034890, -0.259753>, <-0.487504, 0.110269, -0.086320>, <-0.177993, 0.044223, -0.079377>, 
      <-0.876625, 0.479786, -0.736736>, <-0.698783, 0.879711, -0.284105>, <-0.433287, 1.055768, -0.189614>, <-0.191013, 1.008404, -0.203985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.199605, -3.417766, -0.078702>, <0.092221, -3.451013, -0.083683>, <0.264146, -3.172630, -0.308262>, <0.231521, -3.021292, -0.654735>, 
      <-0.215560, -2.351526, -0.006202>, <0.131517, -2.350929, -0.018752>, <0.708005, -2.219629, -0.277168>, <0.348880, -2.385278, -0.688323>, 
      <-0.200632, -1.187197, -0.000653>, <0.131517, -1.136516, -0.003762>, <0.626325, -1.252177, -0.288384>, <0.434822, -1.422402, -0.671298>, 
      <-0.197251, -0.907795, -0.015558>, <0.131517, -0.869009, -0.018276>, <0.584603, -0.986855, -0.299844>, <0.424703, -1.044344, -0.696340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.197251, -0.907795, -0.015558>, <0.131517, -0.869009, -0.018276>, <0.584603, -0.986855, -0.299844>, <0.424703, -1.044344, -0.696340>, 
      <-0.193871, -0.628393, -0.030464>, <0.131517, -0.601502, -0.032789>, <0.542880, -0.721533, -0.311305>, <0.414584, -0.666286, -0.721383>, 
      <-0.177993, 0.044223, -0.079377>, <0.131517, -0.021822, -0.072434>, <0.544910, 0.330530, -0.224271>, <0.468342, -0.047833, -0.752664>, 
      <-0.191013, 1.008404, -0.203985>, <0.051262, 0.961040, -0.218356>, <0.469046, 0.874287, -0.366328>, <0.383703, 0.569068, -0.786615>
    }
  }
  material {
    Plexiglas
  }
  scale <0.623707, 0.234517, 1.009454>
  rotate 45.0*x
  translate  <-0.211844, 2.769317, 5.208995>
}
#declare DropTank2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.399182, -0.088791, 0.310845>, <-0.389568, -0.761777, 0.310845>, <0.370340, -0.743085, 0.310845>, <0.360726, -0.070097, 0.310845>, 
      <-0.699983, -0.088791, 2.103615>, <-0.690369, -0.761777, 2.103615>, <0.671141, -0.743085, 2.103615>, <0.661527, -0.070097, 2.103615>, 
      <-0.739795, -0.088791, 3.896385>, <-0.730181, -0.761777, 3.896385>, <0.710953, -0.743085, 3.896385>, <0.701339, -0.070097, 3.896385>, 
      <-0.545159, -0.088791, 5.689155>, <-0.535545, -0.761777, 5.689155>, <0.516317, -0.743085, 5.689155>, <0.506703, -0.070097, 5.689155>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.360726, -0.070097, 0.310845>, <0.351112, 0.602890, 0.310845>, <-0.408796, 0.584196, 0.310845>, <-0.399182, -0.088791, 0.310845>, 
      <0.661527, -0.070097, 2.103615>, <0.651913, 0.602890, 2.103615>, <-0.709598, 0.584196, 2.103615>, <-0.699983, -0.088791, 2.103615>, 
      <0.701339, -0.070097, 3.896385>, <0.691725, 0.602890, 3.896385>, <-0.749409, 0.584196, 3.896385>, <-0.739795, -0.088791, 3.896385>, 
      <0.506703, -0.070097, 5.689155>, <0.497089, 0.602890, 5.689155>, <-0.554773, 0.584196, 5.689155>, <-0.545159, -0.088791, 5.689155>
    }
  }
  material {
    dkgreen_txt
  }
  scale <0.47227, 0.485802, 0.692576>
  rotate <-90.0, -90.0, 0.0>
  translate  <3.572324, -0.878355, 1.603845>
}
#declare RightBottomFin1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.222888, -0.165324>,
  <0.294843, 0.036149>,
  <0.222888, 0.381189>,
  <-0.194106, 0.064587>,
  <-0.222888, -0.165324>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <1.0, 0.965272, 0.100908>
  rotate <-0.0, -90.0, -0.0>
  translate  <3.589861, -1.604259, 1.249127>
}
#declare RightInsideFin1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.222888, -0.165324>,
  <0.294843, 0.036149>,
  <0.222888, 0.381189>,
  <-0.194106, 0.064587>,
  <-0.222888, -0.165324>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <1.00246, 0.965272, 0.10066>
  rotate <180.0, 31.543314, 180.0>
  translate  <3.802075, -1.60692, 1.730769>
}
#declare RightOutsideFin1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.222888, -0.165324>,
  <0.294843, 0.036149>,
  <0.222888, 0.381189>,
  <-0.194106, 0.064587>,
  <-0.222888, -0.165324>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <1.001066, 0.965272, 0.1008>
  rotate <0.0, 20.166952, -0.0>
  translate  <3.215916, -1.62636, 1.621715>
}
#declare CenterDropTank = union {
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      dkgreen_txt
    }
    scale <0.191615, 0.221019, 1.122323>
    rotate <-90.0, -90.0, 0.0>
    translate  <3.542994, -1.715142, 1.591862>
  }
  sphere { // Sphere003
    <0,0,0>,1
    material {
      dkgreen_txt
    }
    scale <0.257686, 0.688663, 0.271039>
    translate  <3.550203, 2.813134, 1.605643>
  }
  object { DropTank2 }
  object { RightBottomFin1 }
  object { RightInsideFin1 }
  object { RightOutsideFin1 }
  scale <1.0, 1.035977, 0.991006>
  rotate -4.479557*x
  translate  <-3.691798, -1.18829, -3.483508>
}
#declare DropTank1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.399182, -0.088791, 0.310845>, <-0.389568, -0.761777, 0.310845>, <0.370340, -0.743085, 0.310845>, <0.360726, -0.070097, 0.310845>, 
      <-0.699983, -0.088791, 2.103615>, <-0.690369, -0.761777, 2.103615>, <0.671141, -0.743085, 2.103615>, <0.661527, -0.070097, 2.103615>, 
      <-0.739795, -0.088791, 3.896385>, <-0.730181, -0.761777, 3.896385>, <0.710953, -0.743085, 3.896385>, <0.701339, -0.070097, 3.896385>, 
      <-0.545159, -0.088791, 5.689155>, <-0.535545, -0.761777, 5.689155>, <0.516317, -0.743085, 5.689155>, <0.506703, -0.070097, 5.689155>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.360726, -0.070097, 0.310845>, <0.351112, 0.602890, 0.310845>, <-0.408796, 0.584196, 0.310845>, <-0.399182, -0.088791, 0.310845>, 
      <0.661527, -0.070097, 2.103615>, <0.651913, 0.602890, 2.103615>, <-0.709598, 0.584196, 2.103615>, <-0.699983, -0.088791, 2.103615>, 
      <0.701339, -0.070097, 3.896385>, <0.691725, 0.602890, 3.896385>, <-0.749409, 0.584196, 3.896385>, <-0.739795, -0.088791, 3.896385>, 
      <0.506703, -0.070097, 5.689155>, <0.497089, 0.602890, 5.689155>, <-0.554773, 0.584196, 5.689155>, <-0.545159, -0.088791, 5.689155>
    }
  }
  material {
    dkgreen_txt
  }
  scale <0.47227, 0.485802, 0.692576>
  rotate <-90.0, -90.0, 0.0>
  translate  <3.572324, -0.878355, 1.603845>
}
#declare LeftInsideFin = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.222888, -0.165324>,
  <0.294843, 0.036149>,
  <0.222888, 0.381189>,
  <-0.194106, 0.064587>,
  <-0.222888, -0.165324>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <1.001066, 0.965272, 0.1008>
  rotate <-0.0, 20.166952, -0.0>
  translate  <3.212623, -1.631499, 1.676018>
}
#declare BottomLeftTankFin = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.222888, -0.165324>,
  <0.294843, 0.036149>,
  <0.222888, 0.381189>,
  <-0.194106, 0.064587>,
  <-0.222888, -0.165324>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <1.0, 0.965272, 0.100908>
  rotate <-0.0, -90.0, 0.0>
  translate  <3.602601, -1.649239, 1.281196>
}
#declare LeftOutsideFin = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.222888, -0.165324>,
  <0.294843, 0.036149>,
  <0.222888, 0.381189>,
  <-0.194106, 0.064587>,
  <-0.222888, -0.165324>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <1.00246, 0.965272, 0.10066>
  rotate <180.0, 31.543314, 180.0>
  translate  <3.821271, -1.620709, 1.828766>
}
#declare RightDropTank = union {
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      dkgreen_txt
    }
    scale <0.191615, 0.221019, 1.122323>
    rotate <-90.0, -90.0, 0.0>
    translate  <3.542994, -1.715142, 1.591862>
  }
  sphere { // Sphere002
    <0,0,0>,1
    material {
      dkgreen_txt
    }
    scale <0.257686, 0.688663, 0.271039>
    translate  <3.550203, 2.813134, 1.605643>
  }
  object { DropTank1 }
  object { LeftInsideFin }
  object { BottomLeftTankFin }
  object { LeftOutsideFin }
  scale <1.0, 1.035977, 0.991006>
  translate  <-0.882029, -2.926848, -3.039604>
}
#declare DropTank = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.399182, -0.088791, 0.310845>, <-0.389568, -0.761777, 0.310845>, <0.370340, -0.743085, 0.310845>, <0.360726, -0.070097, 0.310845>, 
      <-0.699983, -0.088791, 2.103615>, <-0.690369, -0.761777, 2.103615>, <0.671141, -0.743085, 2.103615>, <0.661527, -0.070097, 2.103615>, 
      <-0.739795, -0.088791, 3.896385>, <-0.730181, -0.761777, 3.896385>, <0.710953, -0.743085, 3.896385>, <0.701339, -0.070097, 3.896385>, 
      <-0.545159, -0.088791, 5.689155>, <-0.535545, -0.761777, 5.689155>, <0.516317, -0.743085, 5.689155>, <0.506703, -0.070097, 5.689155>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.360726, -0.070097, 0.310845>, <0.351112, 0.602890, 0.310845>, <-0.408796, 0.584196, 0.310845>, <-0.399182, -0.088791, 0.310845>, 
      <0.661527, -0.070097, 2.103615>, <0.651913, 0.602890, 2.103615>, <-0.709598, 0.584196, 2.103615>, <-0.699983, -0.088791, 2.103615>, 
      <0.701339, -0.070097, 3.896385>, <0.691725, 0.602890, 3.896385>, <-0.749409, 0.584196, 3.896385>, <-0.739795, -0.088791, 3.896385>, 
      <0.506703, -0.070097, 5.689155>, <0.497089, 0.602890, 5.689155>, <-0.554773, 0.584196, 5.689155>, <-0.545159, -0.088791, 5.689155>
    }
  }
  material {
    dkgreen_txt
  }
  scale <0.47227, 0.485802, 0.692576>
  rotate <-90.0, -90.0, 0.0>
  translate  <3.572324, -0.878355, 1.603845>
}
#declare RightBottomFin = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.222888, -0.165324>,
  <0.294843, 0.036149>,
  <0.222888, 0.381189>,
  <-0.194106, 0.064587>,
  <-0.222888, -0.165324>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <1.0, 0.965272, 0.100908>
  rotate <-0.0, -90.0, -0.0>
  translate  <3.589861, -1.604259, 1.249127>
}
#declare RightInsideFin = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.222888, -0.165324>,
  <0.294843, 0.036149>,
  <0.222888, 0.381189>,
  <-0.194106, 0.064587>,
  <-0.222888, -0.165324>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <1.00246, 0.965272, 0.10066>
  rotate <180.0, 31.543314, 180.0>
  translate  <3.802075, -1.60692, 1.730769>
}
#declare RightOutsideFin = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.222888, -0.165324>,
  <0.294843, 0.036149>,
  <0.222888, 0.381189>,
  <-0.194106, 0.064587>,
  <-0.222888, -0.165324>
  rotate -x*90
  material {
    dkgreen_txt
  }
  scale <1.001066, 0.965272, 0.1008>
  rotate <0.0, 20.166952, -0.0>
  translate  <3.215916, -1.62636, 1.621715>
}
#declare LeftDropTank = union {
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      dkgreen_txt
    }
    scale <0.191615, 0.221019, 1.122323>
    rotate <-90.0, -90.0, 0.0>
    translate  <3.542994, -1.715142, 1.591862>
  }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      dkgreen_txt
    }
    scale <0.257686, 0.688663, 0.271039>
    translate  <3.550203, 2.813134, 1.605643>
  }
  object { DropTank }
  object { RightBottomFin }
  object { RightInsideFin }
  object { RightOutsideFin }
  scale <1.0, 1.035977, 0.991006>
  translate  <-6.486612, -2.98264, -3.014827>
}
#declare DropTankGroup = union {
  object { CenterDropTank }
  object { RightDropTank }
  object { LeftDropTank }
  translate  <-0.211844, -0.341363, 3.713583>
}
#declare EjectionSeat = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.762826, -1.178802, -0.221025>, <-0.668769, -1.199153, -0.123421>, <-0.471188, -1.199153, -0.123421>, <-0.389375, -1.155478, -0.194991>, 
      <-0.829029, -1.053809, -0.930530>, <-0.668769, -1.053809, -0.930530>, <-0.471188, -1.053809, -0.930530>, <-0.310928, -1.053809, -0.930530>, 
      <-0.829029, -1.102334, -1.170431>, <-0.668769, -1.102334, -1.170431>, <-0.471188, -1.102334, -1.170431>, <-0.310928, -1.102334, -1.170431>, 
      <-0.745366, -0.520723, -1.131690>, <-0.602906, -0.520539, -1.134690>, <-0.515290, -0.522547, -1.112977>, <-0.403568, -0.517698, -1.086909>
    }
  }
  material {
    Aluminum
  }
  translate  <0.39559, 4.119502, 0.530892>
}
#declare HeadRestOnTheEjectionSeat = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.118846, 2.450996>,
  <0.881154, 2.450996>,
  <0.731309, 2.941012>,
  <0.166656, 2.736679>,
  <-0.432226, 2.729476>,
  <-0.957473, 2.952538>,
  <-1.118846, 2.450996>
  rotate -x*90
  material {
    red100_txt
  }
  scale <0.134598, 0.378054, 0.223313>
  translate  <-0.157121, 1.984165, 0.236813>
}
#declare EjectionSeatAssembly = union {
  object { EjectionSeat }
  object { HeadRestOnTheEjectionSeat }
  translate  <-0.211844, -0.341363, 3.713583>
}
union { // F105
  object { LandingGear }
  object { WingsGroup }
  object { StabGroup }
  object { FuselageGroup }
  object { CanopyGroup }
  object { RudderFinAndRudder }
  object { FuselageWithACutOutInIt }
  object { RemovableCanopy }
  object { DropTankGroup }
  object { EjectionSeatAssembly }
  translate  <0.211844, 0.341363, -3.713583>
}


plane { // GrassyPlain
  z,0
  material {
    Overcast
  }
  translate  <1.560021, -0.945431, -3.511796>
}






