//------------------------------------------------------------------------------Scenery

#include "SphereMunsellGrid_macro.inc"
#include "HSLM_HSLSphereMunsell.pov"
#include "Axes_macro.inc"
#include "functions.inc"
#include "math.inc"

#declare simple = false;

global_settings
{
	assumed_gamma 1.0
	ambient_light 0.3
	radiosity
	{
		brightness 0.3
	}
}

background {rgb 1}

light_source
{
	<0, 0, 0>            // light's position (translated below)
	color rgb <1, 1, 1>  // light's color
	translate <-30, 30, -30>
	shadowless
}

light_source
{
	<0, 0, 0>            // light's position (translated below)
	color rgb <1, 1, 1>  // light's color
	translate <-30, 30, -30>
	rotate y * 90
	shadowless
}

sky_sphere
{
	pigment
	{
		gradient y
		color_map
		{
			[0.0 rgb <0.6,0.7,1.0>]
			[0.7 rgb <0.0,0.1,0.8>]
		}
	}
}

camera
{
	#local CameraDistance = 10;
	#local ScreenArea = 2;
	#local AspectRatio = image_width/image_height;
//	orthographic
	location -z*CameraDistance
	direction z*CameraDistance
	right     x*ScreenArea*AspectRatio
	up        y*ScreenArea
	rotate x*asind(tand(30))
//	rotate x*90
	rotate y*45
}


//------------------------------------------------------------------------------Pigments


#declare Plain_White = pigment
{
	color <1, 1, 1>
}

#declare Plain_Gray = pigment
{
	color <1/2, 1/2, 1/2>
}

#declare Plain_Black = pigment
{
	color <0, 0, 0>
}

#declare Plain_Clear = pigment
{
	color rgbt <0, 0, 0, 1,>
}


// the coordinate grid and axes
Axes_Macro
(
	10,	// Axes_axesSize,	The distance from the origin to one of the grid's edges.	(float)
	1,	// Axes_majUnit,	The size of each large-unit square.	(float)
	10,	// Axes_minUnit,	The number of small-unit squares that make up a large-unit square.	(integer)
	0.0005,	// Axes_thickRatio,	The thickness of the grid lines (as a factor of axesSize).	(float)
	off,	// Axes_aBool,		Turns the axes on/off. (boolian)
	on,	// Axes_mBool,		Turns the minor units on/off. (boolian)
	off,	// Axes_xBool,		Turns the plane perpendicular to the x-axis on/off.	(boolian)
	on,	// Axes_yBool,		Turns the plane perpendicular to the y-axis on/off.	(boolian)
	off	// Axes_zBool,		Turns the plane perpendicular to the z-axis on/off.	(boolian)
)

#if (simple = false)
object
{
	Axes_Object
	translate -0.000001
//	translate 0.01/2
	no_shadow
	no_reflection
//	no_image
	finish
	{
		ambient 0
	}
	translate -y
}
#end

//------------------------------------------------------------------------------CSG objects

SphereMunsellGrid_Macro
(
	6,			// SphereGrid_radii,		The number of radial divisions.	(integer)
	12,			// SphereGrid_longt,		The number of longitudinal divisions.	(integer)
	6,			// SphereGrid_lattt,		The number of lattitudinal divisions.	(integer)
	1,			// SphereGrid_radius,		The radius of the sphere.	(float)
	0,			// SphereGrid_center,		The center coordinates of the sphere. (vector)
	0.01,			// SphereGrid_thickness,	The thickness of the grid lines. (float)
	off,			// SphereGrid_offset,		Determines whether the divisions are offset by half the amount (sometimes necessary when doing cut-aways at intervals matching the grid's divisions).	(boolian)
	off,
)


#declare sRadius = 1 ;
#declare sCenter = 0 ;
/*
box
{
	0, -sRadius
	pigment
	{
		color rgb 1
	}
}
*/

difference
{
	sphere
	{
		sCenter, sRadius
	}
	#if (simple = false)
	object {SphereMunsellGrid_Object}
	#end
	box {sCenter, <-sRadius,sRadius,-sRadius,>}
	texture
	{
		pigment {HSLM_HSLMSphere}
		finish {ambient 1}
	}
//	no_image
}

#if (simple = false)
polygon
{
	4, <0, 0,>, <1, 0,>, <1, 1,>, <0, 1,>
	pigment
	{
		image_map {png "Hue.png"}
	}
	translate <-0.5, -0.5>
	scale 8/3
	rotate x * 90
	rotate y * -45
	translate y * 0.000001
}

polygon
{
	4, <0, 0,>, <1, 0,>, <1, 1,>, <0, 1,>
	pigment
	{
		image_map {png "Saturation.png"}
	}
	translate <-0.5, -0.5>
	scale 8/3
	translate -z * 0.000001
	rotate z * 45
	rotate y * 90
	translate y * 0.25
}

polygon
{
	4, <0, 0,>, <1, 0,>, <1, 1,>, <0, 1,>
	pigment
	{
		image_map {png "Cylinder_Lightness.png"}
	}
	translate <-0.5, -0.5>
	scale 8/3
//	translate -z * 0.000001
	rotate y * 60
//	translate y * 0.25
}
#end
