#ifndef (GENERAL_INC_INCLUDED)
#declare GENERAL_INC_INCLUDED=1;

#include "colors.inc"
#include "skies.inc"
#include "functions.inc"
#include "math.inc"
#include "screen.inc"

#macro DbgQuality(_name,_q,_info)
  #debug _name #local i=strlen(_name); #while (i<15) #debug "." #local i=i+1; #end
  #debug concat(str(_q,3,0),"  ")
  #debug _info
  #debug "\n"
#end


#macro Fade(vV,vS,vE, vData,vL,vH) // Function: Fading v 0.11 pov@raf256.com
  #local vPow = val( substr(vData,2,strlen(vData)-1) );
  #local vT = substr(vData,1,1);
  #local ret=0.0;     
  #if (  (!strcmp(vT,"c"))|(!strcmp(vT,"C")) ) #local ret=(vL+vH)/2; #end
  #if (  (!strcmp(vT,"s"))|(!strcmp(vT,"S")) ) 
    #if ((vV<vS)|(vV>vE)) #local ret=vL;
    #else #local ret=vH; #end  
  #end
  #if (  (!strcmp(vT,"l"))|(!strcmp(vT,"L")) )     
    #local ret=((vV-vS)/(vE-vS))*(vH-vL)+vL;
    #if (!strcmp(vT,"l")) #local ret=clip(ret,vL,vH); #end
  #end
  #if (  (!strcmp(vT,"e"))|(!strcmp(vT,"E")) )
    #local ret=((vV-vS)/(vE-vS));     
    #if (ret>=0)
      #local ret=pow(ret,vPow)*(vH-vL)+vL;
     #else
      #local ret=-pow(ret,vPow)*(vH-vL)+vL;
     #end 
    #if (!strcmp(vT,"e")) #local ret=clip(ret,vL,vH); #end
  #end
  #if  (!strcmp(vT,"=")) #local ret = (vV=vS)*(vH-vL)+vL; #end
  #if  (!strcmp(vT,"!")) #local ret = (vV!=vS)*(vH-vL)+vL; #end
  
  (ret)
#end   

#macro Fade1(vV,vS,vE, vData) // pov@raf256.com
  Fade(vV,Vs,Ve,vData,0,1)
#end



#end // ii