#declare dataAtomAntiDef = 0.0;
#declare aiAtomPartW1 = <0,0,0>;
#declare aiAtomPartW2 = <0,0,0>;


#if (clock_on)

#ifndef (Clock) #declare Clock=clock; #end

#declare AI_DBG_NEW_FRAME_BANNER = 0;
#declare AI_STEPS_PER_SECOND = 1000; // AI iterations per 1.0 clock (1 sec)

#declare aiThisScriptVersion = "atom-move-AI-cache-0.30-a0";
#declare FileName = "_var/anim/atom_move.ai-cache";

#if (frame_number=initial_frame)
  #fopen AiDbgFile "_var/anim/dbg.dbg" write
  #write (AiDbgFile,"(New AI debug file)\n")
#else  
  #fopen AiDbgFile "_var/anim/dbg.dbg" append
  #if (AI_DBG_NEW_FRAME_BANNER)
    #write (AiDbgFile, concat("*********** Frame #",str(frame_number,5,0)," clock=",str(clock,10,6)),"\n")
  #end  
#end  

#debug "---[ai/avi]-------------------------------------------------------------\n"
#debug concat("[$] AI script - '",aiThisScriptVersion,"' with cache file '",FileName,"'\n")

#declare aiAtomSX = 1.00;
#declare aiAtomSY = 1.00;
#declare aiAtomSZ = 1.00;
#declare aiAtomRotY = 0;
#declare aiAtomSpeed = 0.01;


#declare aiClockStep = 1/AI_STEPS_PER_SECOND;
#declare aiClockLoaded = 0.0;
#declare aiClock       = 0.0;
#declare aiClockTarget = Clock;

#declare ReadFromFile = 0;
#if (file_exists(FileName))
  #declare ReadFromFile = 1;
#else
  #debug "[$] script file doesnt exist"  
#end                       

#if (ReadFromFile)
  #fopen AiFile FileName read

  #declare aiLoadedVersion="(none)";
  #read (AiFile,aiLoadedVersion)
  #if (strcmp(aiThisScriptVersion,aiLoadedVersion)) #debug "[$] cached AI is from old script version" #declare ReadFromFile = 0; #end
  #debug concat("[$] Loaded AI cache is from version= ",aiLoadedVersion,", ")
  #read (AiFile,aiClockLoaded)
  #debug concat("clock= ",str(aiClockLoaded,0,0),"\n")
  #if (aiClockLoaded>aiClockTarget) #debug "[$] cached AI is for never clock" #declare ReadFromFile = 0; #end  
#end

#macro LoadVar(var)
  #read (AiFile,var)
#end

#macro LoadData()
  LoadVar(aiAtomSX)
  LoadVar(aiAtomSY)
  LoadVar(aiAtomSZ)
  LoadVar(aiAtomRotY)
  LoadVar(aiAtomSpeed)
  LoadVar(aiAtomPartW1)
  LoadVar(aiAtomPartW2)
#end

#if (ReadFromFile)
  #debug "[$] Loading data from cache\n"   
  LoadData()
  #if (defined(MyFile))   
    #debug "[!$] error while reading cached AI\n"
  #end
#else
  #declare aiClockLoaded=0;
#end           

#fclose AiFile 
// ===============================================

#debug concat("[$] Recalculating clock ",str(aiClockLoaded,6,10)," --> ",str(aiClockTarget,6,10),"\n")
#declare lit=0; // Local ITerations
#declare aiClock=aiClockLoaded;
  #declare aiAtomOldRotY = aiAtomRotY; // for freezing in linear explosion 
#while (aiClock <= aiClockTarget) 
  #declare vPreserv = 0; // 0=~x[Y]~z or [XYZ]   1=[X][Y]~~z  
  
  #declare aiAtomSpeed = clip(aiAtomSpeed+0.00008, 0,1); // accelerate
  #declare aiAtomRotY = aiAtomRotY + aiAtomSpeed/5000; // rotate
  
  #declare vDef = aiAtomSpeed; // power that defor atom
                     
  // crushing - reducing Y (x=z will adjust)
  #declare vAtomCrush  = clip(pow(max(0,vDef-0.25)*1.2,  1.0), 0,1);
  
  // longen - increasing X (z will adjust)
  #declare vAtomLong   = 2.0 * clip(pow(max(0,vDef-0.65)*1.5,  1.0), 0,1);
  #if (vAtomLong) #declare vPreserv=1; #end
      
  #declare aiAtomSY = 1.00 * 1/(1+(2.5-1)*vAtomCrush);  // deform Y
  // re-deform to preserve volume after Y deform
  #declare aiAtomSX = pow(1/aiAtomSY,1/2);
  #declare aiAtomSZ = pow(1/aiAtomSY,1/2);
  
  #declare aiAtomSX = aiAtomSX + vAtomLong; // deform X
  #declare aiAtomSZ = 1 / (aiAtomSX * aiAtomSY); // re-deform 
  
   // explosion
  #declare timAfterExplode=max(0,Clock-12);
  #declare timLinearPart = (timAfterExplode > 0.5);
  #local vClk=3.0 * timAfterExplode;
  #local dist=vClk*3.0*Fade(vClk, 0.5, 0.9, "e3", 00.3,1.00);
  #local vAnti = Fade(vClk, 0.0, 2.0, "e3", 0,1);
  #declare aiAtomPartW1 = <+dist,0,0> ;
  #declare aiAtomPartW2 = <-dist,0,0> ;
      
  #declare lit=lit+1;
#declare aiClock=aiClock+aiClockStep; #end

  #if (timLinearPart) 
    #declare aiAtomRotY = (aiAtomRotY+aiAtomOldRotY)/2;
    #debug concat("Freeze ROTY at ",str(aiAtomRotY,10,5),"\n")
  #end


#declare dataAtomAntiDef = vAnti;

// correct size to preserv Volume --------------------------
/*
#declare vVEps=0.001; // epsilon
#declare vVTarget=1;
#declare vVSDel=0.1; // size delta (binary-like search)
#declare lit=0; // Local ITerations
#declare vV=-1; #while (abs(vV-vVTarget)>vVEps)
  //#declare vV=pow(aiAtomSX,1)*pow(aiAtomSY,1)*pow(aiAtomSZ,1);
  #declare vV=pow(aiAtomSX,1)*pow(aiAtomSY,1)*pow(aiAtomSZ,1); // * (4/3)*(3.1415);
    
  #declare lit=lit+1; 
  #if (vV<vVTarget)
  #write (AiDbgFile,concat("   +",str(vVSDel,8,5),"\n"))
    #declare aiAtomSX=clip(aiAtomSX+vVSDel,0,50);
    //#declare aiAtomSY=clip(aiAtomSY+vVSDel,0,50); 
    #declare aiAtomSZ=clip(aiAtomSZ+vVSDel,0,50);
  #end
  #if (vV>vVTarget) 
    #write (AiDbgFile,concat("   -",str(vVSDel,8,5),"\n"))
    #declare aiAtomSX=clip(aiAtomSX-vVSDel,0,50);   
    //#declare aiAtomSY=clip(aiAtomSY-vVSDel,0,50); 
    #declare aiAtomSZ=clip(aiAtomSZ-vVSDel,0,50); 
  #end                       
  #declare vVSDel=vVSDel*0.9;
  #write (AiDbgFile,concat("   SV=",str(vV,8,5)," aiAtomS*=<",str(aiAtomSX,8,5),",",str(aiAtomSY,8,5),",",str(aiAtomSZ,8,5),
  ">",str(lit,0,0),"\n")) 
  #if (lit>1000) #error "[!] Infinite loop ?" #end
#end
#write (AiDbgFile,concat("SV=",str(vV,8,5)," aiAtomS*=<",str(aiAtomSX,8,5),",",str(aiAtomSY,8,5),",",str(aiAtomSZ,8,5),
  ">",str(lit,0,0),"\n"))
*/

#write (AiDbgFile,concat("aiAtomS?=<",str(aiAtomSX,8,5),",",str(aiAtomSY,8,5),",",str(aiAtomSZ,8,5),"> \n"))


#declare vAtomVolume = aiAtomSX*aiAtomSY*aiAtomSZ; 
#if (abs(vAtomVolume-1)>0.000001) 
  #error "[!] Invalid atom volume (",str(vAtomVolume,8,5),")\n"
#end

#debug concat("[$] ...done, in ",str(lit,6,0)," iterations, aiClock/Target= ",str(aiClock,6,10)," / ",str(aiClockTarget,6,10),"\n")


// =============================================== 
#debug concat("[$] Writting AI cache (for AiClock=",str(aiClock,0,0),")\n")

#fopen AiFile FileName write
#write (AiFile,concat("\"",aiThisScriptVersion,"\",\n"))
#write (AiFile,aiClock)  #write (AiFile,",\n")


#macro SaveVar(var)
  #write (AiFile,var) #write (AiFile,",\n")
#end

#macro SaveData()
  SaveVar(aiAtomSX)
  SaveVar(aiAtomSY)
  SaveVar(aiAtomSZ)
  SaveVar(aiAtomRotY)
  SaveVar(aiAtomSpeed)
  SaveVar(aiAtomPartW1)
  SaveVar(aiAtomPartW2)
#end

SaveData()

#write (AiFile,"End of AI cache file")

#declare dataAtomSize = <aiAtomSX,aiAtomSY,aiAtomSZ>;
#declare dataAtomRotY = aiAtomRotY;


#debug "---[ai/avi]-------------------------------------------------------------\n"
#end