#include "shapes.inc"
#include "OddTiles.inc"

#declare BuildingTexture =
texture{
  pigment{
    planar
    scale 4
    turbulence 1 lambda 3
    color_map{[0 rgb <1, 0.65, 0.25>][1 rgb <1, 0.7, 0.35>]}
    }
  normal{
    granite -.1 poly_wave .5
    accuracy .001
    }
  }

#declare CeilingTexture = BuildingTexture;

#declare FloorTexture =
texture{
  #local FloorPattern =
  pigment {OddTiles(1,6) rotate x*90 scale 1}
  pigment {
    FloorPattern poly_wave .125
    color_map{[0 rgb <1,0.75,0.5>*.5][1 rgb <1,0.75,0.5>]}
    }
  normal {pigment_pattern{FloorPattern} 1 accuracy .001 poly_wave 1}
  }
  
#declare GroundLevel =
union {
	// the 1st wall
	difference {
		box {<46.5,0,46.5>, <-46.5,5,-46.5>}
		box {<44.2,-1,44.2>, <-44.2,5.1,-44.2>}
		texture {BuildingTexture}
		}

	// 1st level up
	difference {
		box {<47.775,0,47.775>, <-47.775,6,-47.775>}
		box {<46.5,-0.1,46.5>, <-46.5,6.1,-46.5>}
		texture {BuildingTexture}
		}
  
	// 2nd level up
	difference {
		box {<75,0,75>, <-75,7,-75>}
		box {<47.775,-0.1,47.775>, <-47.775,7.1,-47.775>}
		texture {BuildingTexture}
		}

	// the floor
	box {<46.5,.1,46.5>, <-46.5,0,-46.5> texture {FloorTexture}}

	// the ceiling
	box {<0,0,46.5>, <-46.5,0,-46.5> translate y*5.9 texture {CeilingTexture}}
	
	// the sidewalk
	box{<-47,-1,-47>,<3,.1,47> texture {BuildingTexture}}
	};

#declare ArchSegment =
difference {
	// the archway
	union {
		// edge rounding
		#local Rd = 0.1;
		
		// rounded arch
		difference {
			box {<1,0,7>, <-1,6,-7> }
			cylinder {<-1.1,0.0>, <1.1,0,0>, 5+Rd }
			}
		difference {
			box {<1-Rd,0,7>, <-1+Rd,6,-7> }
			cylinder {<-1.1,0.0>, <1.1,0,0>, 5 }
			}

		difference {
			torus {5+Rd, Rd rotate z*90 translate -x*(1-Rd)}
			torus {5+Rd, Rd rotate z*90 translate x*(1-Rd)}
			box {<1.5,0,10>, <-1.5,-6,-10>}
			}
		
		// edge rounding
		#local Rd = 0.05;
		
		// the arch support
		object {Round_Box_Union (<1.5,0,1.5>, <-1.5,12,-1.5>, Rd) translate z*7}
		
		// moulding thickness
		#local Mthk = .1;
		
		// top moulding
		object {Round_Box_Union (<1+Mthk,5.5,7>, <-1-Mthk,6,-7>, Rd) }
		
		// arch moulding
    object {Round_Box_Union (<1+Mthk,0,2+Mthk>, <-1-Mthk,.35,-2-Mthk>, Rd) translate z*7}
    
    // arch support moulding
    object {Round_Box_Union (<1.5+Mthk,0,1+Mthk>, <-1.5-Mthk,.35,-1.5-Mthk>, Rd) translate z*7}
    object {Round_Box_Union (<1.5+Mthk,5.5,1.5+Mthk>, <-1.5-Mthk,6,-1.5-Mthk>, Rd) translate z*7}
    
		// arch support cap		
		#local idx = 0;
		difference {
			box {<1.75,0,1.75>, <-1.75,2,-1.75> }
			#while (idx < 360)
				cylinder {<2,0,0>, <-2,0,0>, 0.25 translate -z*1.75 rotate y*idx }
				#local idx = idx + 90;
			#end
			translate <0,12,7>
			}
		}

	// z axis walkway
	union {
		box {<0.9,0,8.6>, <-0.9,3.1,-8.6> }
		cylinder {<0,0,8.6>, <0,0,-8.6>, 0.9 translate y*3.1}
		translate y*5.9
		}

	// x axis walkway opening
	union {
		box {<0.9,0,8.6>, <-0.9,3.1,-8.6> }
		cylinder {<0,0,8.6>, <0,0,-8.6>, 0.9 translate y*3.1}
		rotate y*90
		translate <0,5.8999999,7>
		}
	translate z*7
	texture {BuildingTexture}
	};

#declare SmlArches =
#local idx = 0;
union {
	#while (idx < 50)
		object { ArchSegment scale 0.35715 rotate y*90 translate <idx,0,0> }
		#local idx = idx + 5;
	#end
	};

#declare FirstLevel =
union {
	object { GroundLevel }
	object { ArchSegment }
	object { ArchSegment translate z*15.5 }
	object { ArchSegment translate z*31 }
	object { ArchSegment translate -z*15.5 }
	object { ArchSegment translate -z*31 }
	object { ArchSegment translate -z*46.5 }
	object { ArchSegment translate -z*62 }
	};

#declare SecondLevelFloor =
union {
	box { <-0.4,0,-0.4>, <50.75,0.01,25> }
	box { <49.5,0,25>, <75,0.01,-50.5> }
	texture {FloorTexture}
	};

#declare ThirdLevelCeiling =
union {
	box { <-0.6,0,-0.6>, <49.4,1,25> }
	cylinder { <-0.6,0,0>, <49.5,0,0>, 0.1 translate -z*0.6 }
	cylinder { <-0.6,0.5,0>, <49.5,0.5,0>, 0.05 translate -z*0.6 }
	cylinder { <-0.6,1,0>, <49.5,1,0>, 0.1 translate -z*0.6 }

	box { <49.4,0,25>, <75,1,-50.6> }
	cylinder { <49.4,0,0.6>, <49.4,0,-50.6>, 0.1 }
	cylinder { <49.4,0.5,0.6>, <49.4,0.5,-50.6>, 0.05 }
	cylinder { <49.4,1,0.6>, <49.4,1,-50.6>, 0.1 }
	texture {CeilingTexture}
	};

#declare SecondLevel =
union {
	object { SecondLevelFloor }
	object { ArchSegment scale 0.35715 rotate y*180 translate z*5 }
	object { SmlArches }
	object { SmlArches translate <0,0,0> rotate y*90 translate x*50 }

	box { <-0.5,0,0>, <-0.4,5,25> texture { BuildingTexture } }
	box { <-0.5,0,24.9>, <75,5,25> texture { BuildingTexture } }
	box { <75,0,25>, <74.9,5,-50.5> texture { BuildingTexture } }
	box { <75,0,-50.5>, <49.5,5,-50.6> texture { BuildingTexture } }
	};

#declare ThirdLevel =
	union {
	object { ArchSegment scale 0.35715 rotate y*180 translate z*5 }
	object { SmlArches }
	object { SmlArches translate <0,0,0> rotate y*90 translate x*50 }
	object { ThirdLevelCeiling translate y*5 }

	box { <-0.5,0,0>, <-0.4,5,25> texture { BuildingTexture } }
	box { <-0.5,0,24.9>, <75,5,25> texture { BuildingTexture } }
	box { <75,0,25>, <74.9,5,-50.5> texture { BuildingTexture } }
	box { <75,0,-50.5>, <49.5,5,-50.6> texture { BuildingTexture } }
	};
