//    Persistence of Vision Ray Tracer version 3.5 Include File
//    File: glass_old.inc
//    Last updated: 2001.8.9
//    Description: Glass finishes and textures (was glass.inc in versions
//    prior to 3.5).
//    Changes in version 3.1: moved refraction and ior to the interior statment.
//    Use I_Glass in conjunction with each of the finish statments below.
//    Version 3.5: Renamed file as glass_old.inc.
//
//    Updated: 07Aug2008(jh)
//    Converted textures to materials see examples below.
//    Removed I_Glass warning.

#ifndef(Glass_Old_Inc_Temp)
#declare Glass_Old_Inc_Temp=version;
#version 3.5;

#ifdef(View_POV_Include_Stack)
    #debug "including glass_old.inc\n"
#end

// Glass Interior
#declare I_Glass =
interior {
    ior 1.5
}
  
// Glass Finishes
#declare F_Glass1 =
finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1
}   
  

#declare F_Glass2 = 
finish {
    ambient 0
    diffuse 0
    reflection 0.5
    phong 0.3
    phong_size 60
}

#declare F_Glass3 =
finish  {
    ambient 0.1
    diffuse 0.1
    reflection 0.1
    specular 0.8
    roughness 0.003
    phong 1
    phong_size 400
}

#declare F_Glass4 =
finish {
    ambient 0.1
    diffuse 0.1
    reflection .25
    specular 1
    roughness 0.001
}

// Glass Textures
// Converted to materials: 07Aug2008 (jh)

// Simple clear glass
#declare M_Glass1 =
material {
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 0.7> }
    finish  { F_Glass1 }
    
} interior {I_Glass}} 

// More like an acrylic plastic
#declare M_Glass2 =
material {
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 1.0> }
    finish  { F_Glass2 }
} interior {I_Glass}}

// An excellent lead crystal glass!
#declare M_Glass3 =
material {
texture {
    pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }
    finish { F_Glass3 }
} interior {I_Glass}}

#declare M_Glass4 =
material {
texture {
    pigment { color rgbf <0.98, 1.0, 0.99, 0.75> }
    finish { F_Glass4 }
} interior {I_Glass}}

#declare M_Old_Glass=
material {
texture {
    pigment { color rgbf <0.8, 0.9, 0.85, 0.85> }
    finish { F_Glass4 }
} interior {I_Glass}}

#declare M_Winebottle_Glass=
material {
texture {
    pigment { color rgbf <0.4, 0.72, 0.4, 0.6> }
    finish { F_Glass4 }
} interior {I_Glass}}

#declare M_Beerbottle_Glass=
material {
texture {
    pigment { color rgbf <0.7, 0.5, 0.1, 0.6> }
    finish { F_Glass4 }
} interior {I_Glass}}

// A few color variations on Norm's glass
// Ruby glass
#declare M_Ruby_Glass =
material {
texture {
    pigment { color rgbf <0.9, 0.1, 0.2, 0.8> }
    finish { F_Glass4 }
} interior {I_Glass}}

#declare M_Green_Glass =
material {
texture {
    pigment { color rgbf <0.8, 1, 0.95, 0.9> }
    finish { F_Glass3 }
} interior {I_Glass}}

#declare M_Dark_Green_Glass=
material {
texture {
    pigment { color rgbf <0.1, 0.7, 0.8, 0.8> }
    finish { F_Glass4 }
} interior {I_Glass}}

#declare M_Yellow_Glass=
material {
texture {
    pigment { color rgbf <0.8, 0.8, 0.2, 0.8> }
    finish { F_Glass4 }
} interior {I_Glass}}

// Orange/Amber glass
#declare M_Orange_Glass=
material {
texture {
    pigment { rgbf <1.0, 0.5, 0.0, 0.8> }
    finish { F_Glass4 }
} interior {I_Glass}}

// Vicks bottle, glass
#declare M_Vicksbottle_Glass=
material {
texture {
    pigment { color rgbf <0.1, 0.15, 0.5, 0.9> }
    finish { F_Glass4 }
} interior {I_Glass}}

#version Glass_Old_Inc_Temp;
#end
