#version unofficial MegaPov 0.5;

#declare quality = 3;

#switch (quality)
  #case (0)
    #include "RadLow.inc"
  #break
  #case (1)
    #include "RadMedium.inc"
  #break
  #case (2)
    #include "RadHigh.inc"
  #break
  #case (3)
    #include "RadUltraHigh.inc"
  #break
#end


camera {
	location <-20.0, 60.0, -75.0>
	sky <0.0, 1.0, 0.0>
 	look_at <-20.0, 0, -5.0>
}

/*
camera {
	location <0.0, 6.0, -50.0>
	sky <0.0, 1.0, 0.0>
 	look_at <0.0, 6.0, -10.0>
}
*/
sphere {
  <0.0, 0.0, 0.0>, 500.0
  pigment {color rgb 1.0}
  finish {ambient 0.75}
  no_shadow
  inverse
}

plane {
  <0, 1, 0>, 0
  pigment {color rgb 1.0}
  finish {
    ambient 0.0
  }
}

#declare RadFinish =
finish {
  ambient 0.0
  diffuse 0.75
}

#declare WindowHole =
union {
  intersection {
    cylinder {<-20.0, 0.0, -3.0>, <20.0, 0.0, -3.0>, 5.0}
    cylinder {<-20.0, 0.0, 3.0>, <20.0, 0.0, 3.0>, 5.0}
    box {<-20.0, -5.0, -0.5>, <20.0, 5.0, 0.5>}
  }
  box {<-20.0, -5.0, -0.5>, <20.0, 0.0, 0.5>}
}

#declare Walls =
difference {
  union {
    box {<-20.0, 0.0, -10.0>, <20.0, 20.0, 10.0>}
    box {<-10.0, 0.0, -50.0>, <10.0, 20.0, 30.0>}
    
    cylinder {<0.0, 0.0, 30.0>, <0.0, 20.0, 30.0>, 10.0}
    cone {<0.0, 20.0, 30.0>, 10.0, <0.0, 30.0, 30.0>, 0.0}
    
    difference {
      box {<-10.0, 20.0, -50.0>, <10.0, 30.0, 30.0>}
      plane {<0.0, -1.0, 0.0>, 0.0 rotate <0.0, 0.0, 45.0> translate <-10.0, 20.0, 0.0>}
      plane {<0.0, -1.0, 0.0>, 0.0 rotate <0.0, 0.0, -45.0> translate <10.0, 20.0, 0.0>}
    }
    
    difference {
      box {<-20.0, 20.0, -10.0>, <20.0, 30.0, 10.0>}
      plane {<0.0, -1.0, 0.0>, 0.0 rotate <-45.0, 0.0, 0.0> translate <0.0, 20.0, -10.0>}
      plane {<0.0, -1.0, 0.0>, 0.0 rotate <45.0, 0.0, 0.0> translate <0.0, 20.0, 10.0>}
    }
    
    difference {
      box {<-3.5, 20.0, -43.5>, <3.5, 80.0, -36.5>}
      plane {<-1.0, 0.0, 0.0>, 0.0 rotate <0.0, 0.0, 20.0> translate <-3.5, 60.0, 0.0>}
      plane {<1.0, 0.0, 0.0>, 0.0 rotate <0.0, 0.0, -20.0> translate <3.5, 60.0, 0.0>}

      plane {<-1.0, 0.0, 0.0>, 0.0 rotate <0.0, 0.0, 20.0> translate <-3.5, 60.0, 0.0> rotate 90.0*y translate -40.0*z}
      plane {<1.0, 0.0, 0.0>, 0.0 rotate <0.0, 0.0, -20.0> translate <3.5, 60.0, 0.0> rotate 90.0*y translate -40.0*z}
    }
  }
  union {
    box {<-18.0, 5.0, -8.0>, <18.0, 21.0, 8.0>}
    box {<-8.0, 5.0, -48.0>, <8.0, 21.0, 28.0>}

    box {<-18.0, 0.5, -8.0>, <18.0, 4.5, 8.0>}
    box {<-8.0, 0.5, -48.0>, <8.0, 4.5, 28.0>}
    
    cylinder {<0.0, 5.0, 28.0>, <0.0, 21.0, 28.0>, 8.0}
    cone {<0.0, 20.0, 30.0>, 8.0, <0.0, 28.0, 30.0>, 0.0}

    box {<-4.0, 5.0, -51.0>, <4.0, 10.0, -47.0>}    // porte avant
    cylinder {<0.0, 10.0, -51.0>, <0.0, 10.0, -47.0>, 4.0}

    difference {
      box {<-8.0, 20.0, -48.0>, <8.0, 28.0, 28.0>}    // toit
      plane {<0.0, -1.0, 0.0>, 0.0 rotate <0.0, 0.0, 45.0> translate <-8.0, 20.0, 0.0>}
      plane {<0.0, -1.0, 0.0>, 0.0 rotate <0.0, 0.0, -45.0> translate <8.0, 20.0, 0.0>}
    }

    difference {
      box {<-18.0, 20.0, -8.0>, <18.0, 30.0, 8.0>}    // toit
      plane {<0.0, -1.0, 0.0>, 0.0 rotate <-45.0, 0.0, 0.0> translate <0.0, 20.0, -8.0>}
      plane {<0.0, -1.0, 0.0>, 0.0 rotate <45.0, 0.0, 0.0> translate <0.0, 20.0, 8.0>}
    }

    box {<-3.0, 15.0, -43.0>, <3.0, 35.0, -37.0>}   // tour

    object {WindowHole translate <0.0, 12.0, -47.5>}
    object {WindowHole translate <0.0, 12.0, -42.5>}
    object {WindowHole translate <0.0, 12.0, -37.5>}
    object {WindowHole translate <0.0, 12.0, -32.5>}
    object {WindowHole translate <0.0, 12.0, -27.5>}
    object {WindowHole translate <0.0, 12.0, -22.5>}
    object {WindowHole translate <0.0, 12.0, -17.5>}
    object {WindowHole translate <0.0, 12.0, -12.5>}

    object {WindowHole translate <0.0, 12.0, 12.5>}
    object {WindowHole translate <0.0, 12.0, 17.5>}
    object {WindowHole translate <0.0, 12.0, 22.5>}
    object {WindowHole translate <0.0, 12.0, 27.5>}

    object {WindowHole rotate 90*y translate <-12.5, 12.0, 0>}
    object {WindowHole rotate 90*y translate <-17.5, 12.0, 0>}
    object {WindowHole rotate 90*y translate <12.5, 12.0, 0>}
    object {WindowHole rotate 90*y translate <17.5, 12.0, 0>}

    object {WindowHole scale <1.0, 0.25, 1.0> translate <0.0, 38.0, -40.0>}
    object {WindowHole scale <1.0, 0.25, 1.0> rotate 90.0*y translate <0.0, 38.0, -40.0>}

    object {WindowHole scale <1.0, 0.25, 1.0> translate <0.0, 33.0, -40.0>}
    object {WindowHole scale <1.0, 0.25, 1.0> rotate 90.0*y translate <0.0, 33.0, -40.0>}
  }
}

#declare Pic0 =
union {
  difference {
    box {<0.0, 0.0, -0.3>, <0.4, 20.0, 0.3>}
    plane {<0.0, -1.0, 0.0>, 0.0 rotate <0.0, 0.0, -30.0> translate <0.0, 20.0, 0.0>}
  }
  difference {
    box {<0.0, 0.0, -0.3>, <0.4, 20.0, 0.3>}
    plane {<0.0, -1.0, 0.0>, 0.0 rotate <0.0, 0.0, -30.0> translate <0.0, 20.0, 0.0>}
    translate <0.4, -8.0, 0.0>
  }
}

#declare Pic1 =
object {Pic0 rotate <0.0, 180.0, 0.0>}

#declare Pic2 =
object {Pic0 rotate <0.0, 90.0, 0.0>}

#declare Pic3 =
object {Pic0 rotate <0.0, 270.0, 0.0>}

#declare Pics =
union {
  object {Pic0 translate <10.0, 1.0, -49.5>}
  object {Pic0 translate <10.0, 0.0, -45.0>}
  object {Pic0 translate <10.0, 0.0, -40.0>}
  object {Pic0 translate <10.0, 0.0, -35.0>}
  object {Pic0 translate <10.0, 0.0, -30.0>}
  object {Pic0 translate <10.0, 0.0, -25.0>}
  object {Pic0 translate <10.0, 0.0, -20.0>}
  object {Pic0 translate <10.0, 0.0, -15.0>}

  object {Pic0 translate <10.0, 0.0, 15.0>}
  object {Pic0 translate <10.0, 0.0, 20.0>}
  object {Pic0 translate <10.0, 0.0, 25.0>}

  object {Pic2 translate <11.0, 0.0, -10.0>}
  object {Pic2 translate <15.0, 0.0, -10.0>}
  object {Pic2 translate <19.5, 1.0, -10.0>}

  object {Pic3 translate <11.0, 0.0, 10.0>}
  object {Pic3 translate <15.0, 0.0, 10.0>}
  object {Pic3 translate <19.5, 1.0, 10.0>}

  object {Pic1 translate <-10.0, 1.0, -49.5>}
  object {Pic1 translate <-10.0, 0.0, -45.0>}
  object {Pic1 translate <-10.0, 0.0, -40.0>}
  object {Pic1 translate <-10.0, 0.0, -35.0>}
  object {Pic1 translate <-10.0, 0.0, -30.0>}
  object {Pic1 translate <-10.0, 0.0, -25.0>}
  object {Pic1 translate <-10.0, 0.0, -20.0>}
  object {Pic1 translate <-10.0, 0.0, -15.0>}

  object {Pic1 translate <-10.0, 0.0, 15.0>}
  object {Pic1 translate <-10.0, 0.0, 20.0>}
  object {Pic1 translate <-10.0, 0.0, 25.0>}

  object {Pic2 translate <-11.0, 0.0, -10.0>}
  object {Pic2 translate <-15.0, 0.0, -10.0>}
  object {Pic2 translate <-19.5, 1.0, -10.0>}

  object {Pic3 translate <-11.0, 0.0, 10.0>}
  object {Pic3 translate <-15.0, 0.0, 10.0>}
  object {Pic3 translate <-19.5, 1.0, 10.0>}

  #local ii = 0;
  #while (ii < 10)
    object {Pic0 translate <9.95, 0.0, 0.0> rotate <0.0, -20 * ii, 0.0> translate <0.0, 0.0, 30.0>}
    #local ii = ii + 1;
  #end

  translate <0.0, -1.0, 0.0>
}

#declare OutsideStairs =
difference {
  union {
    box {<-6.0, 4.8, -53.0>, <6.0, 5.0, -50.0>}
    box {<-6.0, 4.6, -53.5>, <6.0, 4.8, -50.0>}
    box {<-6.0, 4.4, -54.0>, <6.0, 4.6, -50.0>}
    box {<-6.0, 4.2, -54.5>, <6.0, 4.4, -50.0>}
    box {<-6.0, 4.0, -55.0>, <6.0, 4.2, -50.0>}
    box {<-6.0, 3.8, -55.5>, <6.0, 4.0, -50.0>}
    box {<-6.0, 3.6, -56.0>, <6.0, 3.8, -50.0>}
    
    box {<-6.1, 0.0, -55.0>, <-5.9, 6.4, -50.0>}
    box {<5.9, 0.0, -55.0>, <6.1, 6.4, -50.0>}
  }
  plane {<0.0, 0.0, -1.0>, 0.0}
}

union {
  object {Walls}
  object {OutsideStairs}
  object {Pics}

  texture {
    pigment {color rgb <1.0, 1.0, 0.9>}
    finish {RadFinish}
  }
  translate <0.0, -3.0, 0.0>
  rotate <0.0, 45.0, 0.0>
}