// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "WOODS.INC"    // Great wooden textures created by Dan Farmer and Paul Novak
#include "polyhedral.inc"

light_source { <9,9,-9> rgb<1,1,1> }

camera
{
  location  <0.0, 5.0, -10.0>
  look_at   <0.0, 0.0,  0.0>
}

#declare teta=texture{T_Wood9 scale .5}
#declare tetb=texture{pigment{color rgb<1,.9,.9>} finish{reflection .95}}
#declare tetc=texture{pigment{color rgbf<1,1,1,1>}}

union
 {
  polyhedron(19,teta,teta,teta,"f",.05)
  object
   {
    polyhedron(19,tetb,tetc,tetc,"s",.05)
    interior{ior 1.0}
   }
  rotate<0,20,0>  
 }
 
height_field
{
	tga
	"C:\pov\projects\untitled1.tga"
	smooth
  scale <1,2,1>
	translate <-.5, -5, -.5>
	scale <20, 1.00, 20>
	rotate <0, 270, 0>
	pigment
	 {
	  bozo
	  color_map
	   {
	    [0 color Yellow]
	    [.5 color rgb <1,.6,.1>]
	    [1 color Green]
	   }
	  turbulence .5 
	 }
	finish{ambient .3} 
}

plane
{
 <-1,0,0>
 10 
 pigment
  {
   agate
   color_map
    {
     [0 color Blue]
     [.5 color rgb <1,.6,.1>]
     [1 color White]
    }
  }
 finish{ambient .2}  
}
plane
{
 <1,0,0>
 10 
 pigment
  {
   agate
   color_map
    {
     [0 color Blue]
     [.5 color rgb <1,.6,.1>]
     [1 color White]
    }
  }
 finish{ambient .2}  
}
plane{<0,0,1> 10 pigment{Jade}}

// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color White] [1.0 color Black] }
    turbulence 1
    scale 2
  }
}
