
#pragma once
#include <QWidget>
#include <QVector>
#include <QPointF>

class SplineEditorWidget : public QWidget{
    Q_OBJECT
public:
    explicit SplineEditorWidget(QWidget* parent=nullptr);
    const QVector<QPointF>& points() const { return m_pts; }
    bool isClosed() const { return m_closed; }
protected:
    void paintEvent(QPaintEvent*) override;
    void mousePressEvent(QMouseEvent*) override;
    void mouseMoveEvent(QMouseEvent*) override;
    void mouseReleaseEvent(QMouseEvent*) override;
    void keyPressEvent(QKeyEvent*) override;
private:
    QVector<QPointF> m_pts;
    int m_drag=-1;
    bool m_closed=false;
    int hitTest(const QPointF& p,double tol=6.0) const;
    QPointF toWorld(const QPointF& p) const; // identity 2D editor
};
