
#include "SplineEditorWidget.h"
#include <QPainter>
#include <QMouseEvent>
#include <QKeyEvent>

SplineEditorWidget::SplineEditorWidget(QWidget* parent): QWidget(parent)
{
    setMinimumSize(640,360);
}

void SplineEditorWidget::paintEvent(QPaintEvent*)
{
    QPainter g(this);
    g.fillRect(rect(), QColor(20,22,26));

    // Grid
    g.setPen(QColor(40,42,48));
    for(int x=0;x<width();x+=40) g.drawLine(x,0,x,height());
    for(int y=0;y<height();y+=40) g.drawLine(0,y,width(),y);

    // Control polygon
    if(m_pts.size()>0){
        g.setRenderHint(QPainter::Antialiasing,true);
        QPen pen(QColor(80,140,255)); pen.setWidth(2); g.setPen(pen);
        for(int i=0;i<m_pts.size()-1;i++) g.drawLine(m_pts[i], m_pts[i+1]);
        if(m_closed && m_pts.size()>2) g.drawLine(m_pts.last(), m_pts.first());

        // Points
        for(int i=0;i<m_pts.size();++i){
            QRectF r(m_pts[i].x()-4,m_pts[i].y()-4,8,8);
            g.fillRect(r, i==m_drag ? QColor(255,220,100) : QColor(240,240,240));
        }

        // Simple preview curve (linear if no TinySpline)
        g.setPen(QPen(QColor(120,220,180),2,Qt::DashLine));
        for(int i=0;i<m_pts.size()-1;i++) g.drawLine(m_pts[i], m_pts[i+1]);
        if(m_closed && m_pts.size()>2) g.drawLine(m_pts.last(), m_pts.first());
    }
}

int SplineEditorWidget::hitTest(const QPointF& p,double tol) const
{
    for(int i=0;i<m_pts.size();++i){
        if(QLineF(p,m_pts[i]).length()<=tol) return i;
    }
    return -1;
}

QPointF SplineEditorWidget::toWorld(const QPointF& p) const { return p; }

void SplineEditorWidget::mousePressEvent(QMouseEvent* e)
{
    if(e->button()==Qt::LeftButton){
        int h = hitTest(e->pos());
        if(h>=0){ m_drag=h; }
        else { m_pts.push_back(toWorld(e->pos())); m_drag=m_pts.size()-1; update(); }
    }
    if(e->button()==Qt::RightButton){
        m_closed = !m_closed; update();
    }
}

void SplineEditorWidget::mouseMoveEvent(QMouseEvent* e)
{
    if(m_drag>=0){ m_pts[m_drag]=toWorld(e->pos()); update(); }
}

void SplineEditorWidget::mouseReleaseEvent(QMouseEvent*)
{ m_drag=-1; }

void SplineEditorWidget::keyPressEvent(QKeyEvent* e)
{
    if(e->key()==Qt::Key_Delete){
        int h = (m_drag>=0? m_drag : hitTest(mapFromGlobal(QCursor::pos())));
        if(h>=0){ m_pts.remove(h); m_drag=-1; update(); }
    }
    if(e->key()==Qt::Key_C){ m_closed=!m_closed; update(); }
}
