#version 3.7;
background { rgb <0.08,0.08,0.10> }
#declare S_FONT="DejaVuSansMono.ttf";
#declare S_THICK=0.03; #declare S_SIZE=0.06; #declare S_LINE_H=0.10;
#macro M_SPAN(TEXT, V_RGB, V_POS)
  #local T=text{ttf S_FONT TEXT S_THICK,0}
  object{T texture{pigment{color V_RGB} finish{ambient 1 diffuse 0}} scale S_SIZE translate V_POS}
#end
#macro M_SPAN_WIDTH(TEXT)
  #local T=text{ttf S_FONT TEXT S_THICK,0}
  #local BB=max_extent(T)-min_extent(T); (BB.x)*S_SIZE
#end
#include "pov_highlight.inc"
#macro M_DRAW_CODE(V_ORIGIN, USE_MEASURED)
  #local i=0; #while(i<A1D_LINES)
    #local X=0; #local j=0; #local N=dimension_size(A2D_CODE[i],1);
    #while(j<N)
      #local S_TEXT=A2D_CODE[i][j];
      #local V_RGB =A2D_CODE[i][j+1];
      #local V_POS =V_ORIGIN + <X, -S_LINE_H*i, 0>;
      M_SPAN(S_TEXT,V_RGB,V_POS)
      #if(USE_MEASURED)
        #local X=X+M_SPAN_WIDTH(S_TEXT);
      #else
        #local X=X+S_SIZE*0.62*strlen(S_TEXT);
      #end
      #local j=j+2;
    #end
    #local i=i+1;
  #end
#end
camera { location <0,1.6,-4.2> look_at <0,1.0,0> right x*image_width/image_height angle 35 }
light_source { < 3,6,-5> rgb 1 } light_source { <-3,4,5> rgb <1,0.95,0.9> }
M_DRAW_CODE(<-3.2,1.5,0>,0)
