
# POV-Ray Conversation Code & Instructions Pack

This archive consolidates the code and instructions we created in this conversation:

1. **SDL Name-Indirection PoC (dynamic identifiers)** — `getvar/setvar/exists/undefvar` built-ins and a patch sketch to add them to POV-Ray's parser (version-gated). Includes Git steps, unified diffs, and a demo scene.
2. **Render POV source as colorized 3D text** — pre-frame Python generator (`povsrc_to_inc.py`) and a scene that lays out syntax-colored `text{}` spans.
3. **Rising bubbles include** — physically plausible, clock-driven buoyancy–drag with Boyle-law radius growth and wobble, ready to drop into any container.
4. **VS Code “POV Tabs Preview”** — extension skeleton & CLI bundle (if present) to preview `// @tab BEGIN/END` sections as tabs.
5. **Conversation summary** — a concise transcript capturing the key guidance.

Each module folder contains a `README.md` and runnable examples.

---
## Quick Index

- `name_indirection/` — Git branch instructions, patch diff, demo scene
- `highlight_renderer/` — `povsrc_to_inc.py`, `render_code_as_text.pov`, and INI
- `bubbles/` — `BUBBLE_RISE.inc`, demo scene, INI
- `vs-code/` — VS Code extension bundle zip (if present) and notes
- `conversation/` — transcript summary

---
## References
- Parser/tokenizer architecture and files: GitHub source tree under `source/parser/` (e.g., `parser.cpp`, `parser_tokenizer.cpp`, `scanner.cpp`).
- Language directives and parsing options (`#version`, INI `Version=`) are documented in the official POV-Ray docs.

