// BUBBLE_RISE.inc — excerpt
#declare S_G=9.81; #declare S_RHO_L=1000; #declare S_MU_L=1e-3; #declare S_P_SURF=101325; #declare S_H_LIQ=0.30;
#declare S_LIQUID_LEVEL=0.0;
#declare OBJECT_CONTAINER = cylinder { <0,-S_H_LIQ,0>, <0,0.02,0>, 0.06 }
#declare OBJECT_LIQUID = intersection { object{OBJECT_CONTAINER} plane{ y,S_LIQUID_LEVEL } inverse }
#declare S_PRESSURE = function(Y){ S_P_SURF + S_RHO_L*S_G*(0 - Y) }
#declare S_RADIUS_BY_Y=function(R0,Y){ R0*pow(S_P_SURF/S_PRESSURE(Y),1/3) }
#declare S_CLAMP=function(X,A,B){ min(max(X,A),B) }
#declare S_CD=function(RE){ #local REp=max(RE,1e-6); #local CD_st=24/REp; #local t=S_CLAMP((log(REp)-log(1))/(log(200)-log(1)),0,1); (1-t)*CD_st + t*0.44 }
#declare S_VTERM=function(R,CD){ sqrt((8/3)*R*S_G/max(CD,1e-6)) }
#declare S_TAU=function(R,CD){ (4/3)*R/(max(CD,1e-6)*max(S_VTERM(R,CD),1e-6)) }
#declare S_WOBBLE_AMP=function(R,VT){ 0.5*R*(1-exp(-VT/0.15)) }
#declare S_WOBBLE_FREQ=function(R,VT){ 0.25*VT/max(R,1e-6) }
#macro M_RSEED(SEED) #local _r=seed(SEED); _r #end
#macro M_RAND01(RS) #local _x=rand(RS); _x #end
#macro M_BUBBLE_RECORD(V_ORIGIN,S_R0,S_TBIRTH,S_SEED)
  #local RS=M_RSEED(S_SEED); #local XPH=2*pi*M_RAND01(RS); #local ZPH=2*pi*M_RAND01(RS); #local WXY=0.4+0.6*M_RAND01(RS);
  array[8]{ V_ORIGIN,S_R0,S_TBIRTH,S_SEED,XPH,ZPH,WXY,0 }
#end
#macro M_BUBBLE_OBJECT(REC,S_TLOCAL,OBJECT_OUT)
  #local V_O=REC[0]; #local R0=REC[1]; #local TL=S_TLOCAL;
  #if (TL<0) #declare OBJECT_OUT=object{sphere{<0,0,0>,0} no_shadow}; #else
    #local CD0=S_CD(100); #local VT0=S_VTERM(R0,CD0); #local TAU0=S_TAU(R0,CD0);
    #local dY1=VT0*(TL - TAU0*(1-exp(-TL/TAU0))); #local Y1=V_O.y+dY1;
    #local R1=S_RADIUS_BY_Y(R0,Y1); #local CD1=S_CD( max( (2*R1)*VT0*S_RHO_L/S_MU_L,1) );
    #local VT1=S_VTERM(R1,CD1); #local TAU1=S_TAU(R1,CD1);
    #local dY=VT1*(TL - TAU1*(1-exp(-TL/TAU1))); #local YY=V_O.y+dY; #local RR=S_RADIUS_BY_Y(R0,YY);
    #local AMP=S_WOBBLE_AMP(RR,VT1); #local F=S_WOBBLE_FREQ(RR,VT1);
    #local X=V_O.x + AMP*sin(2*pi*F*TL+REC[4]); #local Z=V_O.z + AMP*cos(2*pi*F*TL+REC[5]);
    #declare OBJECT_OUT = object{ sphere{ <X,YY,Z>, RR } texture{ pigment{ rgbt <1,1,1,1> } finish{ ambient 0 diffuse 0 } } no_shadow };
  #end
#end
#macro M_BUBBLE_SYSTEM(S_N,V_BASE,S_BAND_R,S_RMIN,S_RMAX,S_TMIN,S_TMAX,S_SEED0,ARR_OUT)
  #local RSYS=M_RSEED(S_SEED0); #local A=array[S_N]; #local I=0; #while(I<S_N)
    #local ang=2*pi*M_RAND01(RSYS); #local rad=S_BAND_R*sqrt(M_RAND01(RSYS));
    #local x=V_BASE.x+rad*cos(ang); #local z=V_BASE.z+rad*sin(ang); #local y=V_BASE.y;
    #local r0=S_RMIN+(S_RMAX-S_RMIN)*M_RAND01(RSYS);
    #local tb=S_TMIN+(S_TMAX-S_TMIN)*M_RAND01(RSYS);
    #local sd=int(1e6*M_RAND01(RSYS)); #local rec=M_BUBBLE_RECORD(<x,y,z>,r0,tb,sd); #local A[I]=rec; #local I=I+1; #end
  #declare ARR_OUT=A;
#end
#macro M_DRAW_BUBBLES(ARR,S_TGLOBAL)
  #local N=dimension_size(ARR,1); #local i=0; #while(i<N)
    #local REC=ARR[i]; #local TL=S_TGLOBAL-REC[2]; #local OBJ=object{sphere{<0,0,0>,0}}; M_BUBBLE_OBJECT(REC,TL,OBJ) object{OBJ}
    #local i=i+1; #end
#end
