#include "geometry.h"
using namespace std;
using namespace geometry;

point3d::point3d() :
    coords()
{}

point3d::point3d(const double &_X, const double &_Y, const double &_Z) :
    coords{_X, _Y, _Z}
{}

point3d::~point3d() {}

double point3d::operator [](pointName N) const
{
    if(N > Z && N < X)
        throw out_of_range("point3d index out of range.");

    return coords[N];
}

double &point3d::operator [](pointName N)
{
    if(N > Z && N < X)
        throw out_of_range("point3d index out of range.");

    return coords[N];
}

bool point3d::operator ==(const point3d &rhs)
{
    return ((*this)[X] == rhs[X] && 
            (*this)[Y] == rhs[Y] &&
            (*this)[Z] == rhs[Z]);
}

bool point3d::operator !=(const point3d &rhs)
{
    return !(*this == rhs);
}

point3d &point3d::operator =(const point3d &rhs)
{
    int i;

    for(i = 0; i < 3; i++)
        coords[i] = rhs.coords[i];

    return *this;
}

point3d point3d::operator -()
{
    return point3d(-coords[X], -coords[Y], -coords[Z]);
}

//ostream &point3d::operator <<(ostream &os)
//{
////    os << "(" << coords[X] << ", " << coords[Y] << ", " << coords[Z] << ")" << endl;

//    return os;
//}

//ostream &operator <<(ostream &os, const point3d &P)
//{
//    os << "(" << P.coords[X] << ", " << P.coords[Y] << ", " << P.coords[Z] << ")" << endl;

//    return os;
//}
