#include <iostream>
#include <cstdlib>
#include "geometry.h"
using namespace std;
using namespace geometry;

void point_constructor_test(void);
void point_bracket_operator_test(void);
void point_arithmetic_test(void);
void point_logic_test(void);

int main()
{
    cout << "Testing point3d constructors..." << endl;
    point_constructor_test();
    cout << "Done" << endl;

    cout << "Testing point3d bracket operators..." << endl;
    point_bracket_operator_test();
    cout << "Done" << endl;

    cout << "Testing point3d arithmetic operations..." << endl;
    point_arithmetic_test();
    cout << "Done" << endl;

    cout << "Testing point3d logic operations..." << endl;
    point_logic_test();
    cout << "Done" << endl;

    return EXIT_SUCCESS;
}

void point_constructor_test(void)
{
    point3d p1;
    point3d p2(3.0, 4.0, 5.0);
}

void point_bracket_operator_test(void)
{
    point3d p1;

    cout << "Testing Access operators." << endl;
    cout << "p1: (" << p1[X] << ", " << p1[Y] << ", " << p1[Z] << ")" << endl;

    cout << "Setting p1[X] = 3.0...";
    p1[X] = 3.0;
    cout << (p1[X] == 3.0 ? "pass" : "fail") << endl;
}

void point_arithmetic_test(void)
{
    point3d p1(3.0, 4.0, 5.0);

    cout << "Testing negation:" << endl;
    cout << "p1: " << p1 << endl;
    cout << "-p1: " << (-p1) << " ... ";
    cout << (-p1 == point3d(-3.0, -4.0, -5.0) ? "pass" : "fail") << endl;
}

void point_logic_test(void)
{

}
