// -w240 -h180 +a0.3
camera { location  <0, 0, -9> look_at <0, -0.5, 0>}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

#declare R1=3;
#declare R2=1.5;

#declare Fx = function(u,v){cos(u)*(R1 + R2*cos(v))}
#declare Fy = function(u,v){sin(u)*(R1 + R2*cos(v))}
#declare Fz = function(u,v){R2*sin(v)}

#include "param.inc"

object{
  Parametric(
    Fx, Fy, Fz,
    <0,0>,<2*pi,2*pi>,
    50,50,""
  )
  texture {
    pigment { uv_mapping 
      function{u*7/pi}
      colour_map {[0.5 rgb y][0.5 rgb 1]}
    }
  }
  texture {
    pigment { uv_mapping 
      function{v*7/pi}
      colour_map {[0.4 rgb x][0.4 rgbt 1]}
    }
    finish {
      phong 0.5
      phong_size 10
    }
  }
  no_shadow
  rotate x*50
}
