
camera { location  <4, 2, -5> look_at <0, 0, 0> angle 25}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<-100,200,-100> colour rgb 1.5}

// ----------------------------------------




#declare S = function {
   spline {
     natural_spline
      -1, < 0.5, 0, 0.0>,
    -0.5, < 0.2, 0, 0.4>,
     0.0, < 0.2, 0, 0.2>,
     0.5, < 0.4, 0, 0.4>,
       1, < 0.0, 0,-0.6>
   }
 }


isosurface {
  function { y - S(x).x - S(z).z }
        max_gradient 2
        contained_by{box{-1,1}} open
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
        no_shadow
}

box{-1,1 pigment {rgbt <1,0,0,0.9>}}

#declare ctr = -1;
#while (ctr < 1)
  sphere {<ctr, S(ctr).x, -1> ,.04  pigment { rgb x }  }
  sphere {<1,  S(ctr).z, ctr> ,.04  pigment { rgb y }  }
  #declare ctr = ctr + 0.01;
#end

