// -w240 -h180 +a0.3
camera { location  <0, 50, -90> look_at <0, 0, 0> angle 16}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare R1=4;
#declare R2=3.8;
                                          
#declare Fx = function(u,v){cos(u)*(R1 + R2*cos(v)) + pow((v/pi),100)}
#declare Fy = function(u,v){sin(u)*(R1 + R2*cos(v)) + 0.25*cos(5*u)}
#declare Fz = function(u,v){-2.3*ln(1 - v*0.3157) + 6*sin(v) +2*cos(v)}

#include "param.inc"

object{
    Parametric(
       Fx, Fy, Fz,
       <FromU(0),FromV(-pi)>,<ToU(2*pi),ToV(pi)>,
       60,200,""
    )
    pigment { bozo
      colour_map {
        [0.3 rgb <1,0.5,0>]
        [1   rgb <0.5,1,0>]
      }
      scale 7
    }
    finish {
      phong 0.3
      phong_size 8
      }
  no_shadow
  rotate -x*90
}



