// -w240 -h180 +a0.3
camera { location  <0, 0, -30> look_at <0, 3.5, 0> angle 25}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1.5}
light_source {<-100,-200,-100> colour rgb 0.5}


sphere {0,20 
  pigment {checker rgb 0, rgb 1 scale 2}
  no_image
  no_shadow
}

#declare Flare=function(u){u/(2*pi) + pow(u/(2*pi),20)*2}

//#declare Fx = function(u,v){(2 + cos(v))*sin(u)}
//#declare Fy = function(u,v){(2 + cos(v))*cos(u)}
//#declare Fz = function(u,v){sin(v)}


#declare Fx = function(u,v){(2 + u/(2*pi)*cos(v))*sin(u) - 0.1*u}
#declare Fy = function(u,v){(2 + Flare(u)*cos(v))*cos(u) + 0.5*u}
#declare Fz = function(u,v){Flare(u)*sin(v)}

parametric {
  function {Fx(u,v)}
  function {Fy(u,v)}
  function {Fz(u,v)}
      <0.0001,0>,<2*pi,2*pi>
  contained_by{box{<-3.3,-1,-3><2.1,8.2,3>}}
  precompute 18, x,y,z
  pigment {rgb <1,.8,0>}
  finish {
    phong 0.5
    phong_size 10
    reflection 0.3
  }
  no_shadow
  rotate <0,70,0>
}
