// Wallis's Conical Edge - a type of right conoid


camera { location  <10, 10, -30> look_at <0, 1.5, 0> angle 15}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare a=3;
#declare b=3; // problems occur if b < a
#declare c=1.0;

#declare Fx = function(u,v){ v*cos(u) }
#declare Fy = function(u,v){ c*pow( (a*a-b*b*cos(u)*cos(u)), 0.5) }
#declare Fz = function(u,v){ v*sin(u) }

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<-pi,0>,<pi,4>,50,50,"")
  pigment {uv_mapping checker rgb 0.9 rgb 0.85 scale 0.4}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
