//Triaxial Hexatorus

camera { location  <0, 0, -30> look_at <0, 0, 0> angle 10}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}



#declare Fx = function(u,v){ sin(u)/(sqrt(2)+cos(v)) }
#declare Fy = function(u,v){ sin(u+2*pi/3)/(sqrt(2)+cos(v+2*pi/3)) }
#declare Fz = function(u,v){ cos(u-2*pi/3)/(sqrt(2)+cos(v-2*pi/3)) }

#include "param.inc"


object {Parametric(Fx,Fy,Fz,<-pi,-pi>,<pi,pi>,40,40,"")
  pigment {uv_mapping checker rgb 0.95 rgb 0.85 scale 0.2}
  finish {phong 0.5 phong_size 10}
  rotate <0,45,45>
  no_shadow
}
