//Klein Bottle Two

camera { location  <0, 0, -30> look_at <0, 0, 0> angle 18}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}



#declare Fx = function(u,v){ (2 + cos(v/2)*sin(u)-sin(v/2)*sin(2*u))*cos(v) }
#declare Fy = function(u,v){ (2 + cos(v/2)*sin(u)-sin(v/2)*sin(2*u))*sin(v) }
#declare Fz = function(u,v){ sin(v/2)* sin(u)+cos(v/2)*sin(2*u) }

#include "param.inc"


object {Parametric(Fx,Fy,Fz,<0,0>,<2*pi,2*pi>,40,80,"")
  pigment {uv_mapping checker rgb 0.95 rgb 0.85 scale 0.15}
  finish {phong 0.5 phong_size 10}
  rotate y*25
  no_shadow
}
