//Henneberg's Minimal Surface

camera { location  <-10, 10, -30> look_at <0, 2, 0> angle 30}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare Fx = function(u,v){ 2*sinh(u)*cos(v) -sinh(3*u)*cos(3*v)*2/3 }
#declare Fy = function(u,v){ 2*cosh(2*u)*cos(2*v) }
#declare Fz = function(u,v){ 2*sinh(u)*sin(v) -sinh(3*u)*sin(3*v)*2/3 }

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<-1,-.94>,<1,.94>,50,50,"")
  pigment {uv_mapping checker rgb 0.95 rgb 0.85 scale 0.15}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
