//Helix

camera { location  <0, 0, -30> look_at <0, 0, 0> angle 10}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare H=0.3;
#declare R=0.2;

#declare Fx = function(u,v){ (1-R*cos(v))*cos(u) }
#declare Fy = function(u,v){ (1-R*cos(v))*sin(u) }
#declare Fz = function(u,v){ R*(sin(v)) + u*H }

#include "param.inc"


object {Parametric(Fx,Fy,Fz,<-10,0>,<10,2*pi>,100,20,"")
  pigment {uv_mapping checker rgb 0.95 rgb 0.85 scale 0.25}
  finish {phong 0.5 phong_size 10}
  rotate y*60
  no_shadow
}
