
camera { location  <-10, 10, -30> look_at <0, 1.3, 0> angle 20}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare Fx = function(u,v){ u-sin(u)*cosh(v) }
#declare Fy = function(u,v){ 4*sin(u/2)*sinh(v/2) }
#declare Fz = function(u,v){ 1-cos(u)*cosh(v) }

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<-pi*3,-2>,<pi*3,2>,150,50,"")
  pigment {uv_mapping checker rgb 0.9 rgb 0.85 scale 0.3}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
