//Bent Horns

camera { location  <1,-3, -30> look_at <1, -3, 0> angle 20}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare Fx = function(u,v){ (2+cos(u))*(v/3-sin(v)) }
#declare Fy = function(u,v){ (2+cos(u - 2*pi/3))*(cos(v)-1) }
#declare Fz = function(u,v){ (2+cos(u + 2*pi/3))*(cos(v)-1) }

#include "param.inc"


object {Parametric(Fx,Fy,Fz,<-pi,0*pi>,<pi,pi>,40,40,"")
  pigment {uv_mapping checker rgb 0.95 rgb 0.85 scale 0.2}
  finish {phong 0.5 phong_size 10}
}
