/* The Barth Decic is the decic equation with the highest
   possible number of ordinary double points (345) */


camera { location  <0, 0, -10> look_at <0, 0, 0> angle 20}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 rgb <.3,.3,.8>] [1.0 color rgb 1] }
  }
}

light_source {<30,200,-30> colour rgb 1}
light_source {<-30,200,-100> colour rgb 0.5}
light_source {<0,20,-100> colour rgb 0.5}
                     
#declare GR=1.6180339887; // Golden ratio
#declare GR2=GR*GR;
#declare GR4=GR2*GR2;
                     
#declare BarthDecic=function(x,y,z,w) {
   8*(x*x - GR4*y*y)*(y*y - GR4*z*z)*(z*z - GR4*x*x)
     *(x*x*x*x + y*y*y*y + z*z*z*z - 2*x*x*y*y - 2*x*x*z*z - 2*y*y*z*z)
   +(3+5*GR)*pow((x*x + y*y + z*z - w*w),2)
     *pow((x*x + y*y +z*z - (2 - GR)*w*w),2)*w*w
 } 
   
   
isosurface {
  function { BarthDecic(x,y,z,1.0) }
        max_gradient 370
        contained_by{sphere {0,1.2}} open
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
}
   