// -w240 -h180 +a0.3
#include "functions.inc"

camera { location  <4, 0, -10> look_at <4, 0, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] } 
  }
}

light_source {<-100,200,-100> colour rgb 1}

#declare A=array[8];
#declare SEED=seed(3);
#declare n=0;
#while (n<8)
  #declare A[n]=rand(SEED)+0.5;
  #declare n=n+1;
#end

#declare F_cylinder=function(x,y,z,r){f_sphere(0,y,z,r)}

#declare Index=function(i){
  select(i-4,
    select(i-2,
      select(i-1,A[0],A[1]),
      select(i-3,A[2],A[3])
    ),
    select(i-6,
      select(i-5,A[4],A[5]),
      select(i-7,A[6],A[7])
    )
  )
}

isosurface {
  function {F_cylinder(x,y,z,Index(x))}
  max_gradient 10
  contained_by{box {<0,-2,-2>,<8,2,2>}} open
  pigment {rgb .9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
