//To see the real isosurface: #declare approximateISO = no;
//To produce a smooth_triangle approximation: #declare approximateISO = yes; #declare isoSmooth = yes; 
//To produce a flat triangle approximation: #declare approximateISO = yes; #declare isoSmooth = no; 

#include "functions.inc" 

#declare R=1.5;

camera { location  <1*R, 2*R, -4*R> look_at <0, 0, 0> angle 32}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------

#declare f = function {f_torus(x,y,z,1,0.4)}
#declare Fn = function {f_torus(x,y,z,1,0.4)}


#declare approximateIso = yes; // Set true to produce the approximation, false for actual isosurface

#declare isoMin = <-R,-R,-R>;
#declare isoMax = <R,R,R>;

#if(approximateIso)
  #declare isoSmooth = yes;
  #declare isoSegs = <15, 15, 15>;
  #declare isoFileOption = 1;
  #declare isoFile = "KL01.iso";
  #declare isoName = "Surface";
  #include "isosurfacejf9.inc"
  object { Surface
    pigment {rgb 0.9}
    finish {phong 0.5 phong_size 10}
  }
#else
  isosurface {
    function { f(x,y,z)}
    max_gradient 1.1
    contained_by{box {isoMin,isoMax}} open
    pigment {rgb 0.9}
    finish {phong 0.5 phong_size 10}
  }
#end