#include "functions.inc"

camera { location  <0, 2,-3> look_at <0, 0.1, 0> angle 50}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<-100,200,-100> colour rgb 1}

// ----------------------------------------


#declare P=function{pigment{leopard
   colour_map{[0.0  rgb 0.0]
              [0.3  rgb 0.0]
              [1.0  rgb 1.0]}
   scale 0.1
   }}


isosurface {
  function { y - P(x,0,z).red*0.4}
        max_gradient 4
        contained_by{box{<-2,-0.1,-2>,2}}
        pigment {rgb 0.9}
        finish {phong 0.5 phong_size 10}
}

