
#declare R=2;

camera { location  <1*R, 2*R, -4*R> look_at <0, 0, 0> angle 20}

sky_sphere { pigment {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                

#declare Fx = function {sin(u)*sin(v) +cos(20*v)*0.05}
#declare Fy = function {cos(u)*sin(v) +cos(20*u)*0.05}
#declare Fz = function {cos(v)}//        +sin(20*u)*0.05}
                        
#declare U1 = -1*pi;
#declare U2 =  1*pi;
#declare V1 = -1*pi;                       
#declare V2 =  1*pi;

parametric {
  function {Fx(u,v,0)}
  function {Fy(u,v,0)}
  function {Fz(u,v,0)}
      <U1,V1>,<U2,V2>
  contained_by{box{<-R,-R,-R>,<R,R,R>}}
  precompute 18, x,y,z
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
      
