
#declare R=2;

camera { location  <2*R, 1*R, -4*R> look_at <0, 0, 0> angle 18}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                

#declare Fx = function(u,v) {sin(u)*sin(v) + cos(20*u)*0.1}
#declare Fy = function(u,v) {cos(u)*sin(v) + sin(20*u)*0.1}
#declare Fz = function(u,v) {cos(u)*cos(v)}
                        
#declare Umin = -1*pi;
#declare Umax =  1*pi;
#declare Vmin = -1*pi;                       
#declare Vmax =  1*pi;

#declare Iter_U = 100;
#declare Iter_V = 100;

#include "param.inc"
Parametric()


object {Surface
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
      
