
#declare R=0.6;

camera { location  <2*R, 2*R, -4*R> look_at <0, 0, 0> angle 35}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                
//Swallowtail
//
//A classic curve from Catastrophy theory. Parametric form:

#declare Fx = function {u*v*v + 3*pow(v,4)}
#declare Fy = function {-2*u*v - 4*pow(v,3)}
#declare Fz = function {u}
                        
#declare U1 = -2;
#declare U2 =  2;
#declare V1 = -0.8;                       
#declare V2 =  0.8;

parametric {
  function {Fx(u,v,0)}
  function {Fy(u,v,0)}
  function {Fz(u,v,0)}
      <U1,V1>,<U2,V2>
  contained_by{box{<-R,-R,-R>,<R,R,R>}}
  precompute 18, x,y,z
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
      
//box {-R,R pigment {rgbt <1,0,0,0.95>}}
