#declare R=1.3;

camera { location  <1*R, 1*R, -4*R> look_at <0, 0, 0> angle 32}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                
//Moebius strip
                               

#declare Fx = function {cos(u)+v*cos(u/2)*cos(u)}
#declare Fy = function {sin(u)+v*cos(u/2)*sin(u)}
#declare Fz = function {v*sin(u/2)}
                        
#declare U1 = 0;
#declare U2 = 2*pi;
#declare V1 = -0.3;                       
#declare V2 = 0.3;

parametric {
  function {Fx(u,v,0)}
  function {Fy(u,v,0)}
  function {Fz(u,v,0)}
      <U1,V1>,<U2,V2>
  contained_by{box{<-R,-R,-R>,<R,R,R>}}
  precompute 18, x,y,z
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
      
