#declare R=0.9;

camera { location  <2*R, 2*R, -4*R> look_at <0, 0, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                
//Astrodal Ellipsoid
//This surface goes in where the ellipsoid goes out. Which gives the surface an overall hyperbolic look.



#declare A=1;
#declare B=1;
#declare C=1;                                
                                

#declare Fx = function {pow((A*cos(u)*cos(v)),3)}
#declare Fy = function {pow((B*sin(u)*cos(v)),3)}
#declare Fz = function {pow((C*sin(v)),3)}


parametric {
  function {Fx(u,v,0)}
  function {Fy(u,v,0)}
  function {Fz(u,v,0)}
      <0,0>,<2*pi,2*pi>
  contained_by{box{<-R,-R,-R>,<R,R,R>}}
  precompute 18, x,y,z
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
      
box {-R,R pigment {rgbt <1,0,0,0.95>}}
