#include "functions.inc"

camera { location  <0, 3, -4>*5 look_at <0, 0, 0> angle 13}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}

// ----------------------------------------

#declare R1=0.15;    // helix minor radius
#declare R2=0.3;     // helix major radius
#declare R3=2.0;     // torus major radius
#declare Strands=3;  // DNA = double strand

#declare Turns=6;    // number of helix turns in the loop
                     // Turns*Strands should be an integer
                     // to avoid a discontinuity 

#declare F=function { f_helix1 (x, z, y, Strands, Turns, R1, R2, 0.6, 2, 0) }

isosurface {
   function{F(f_r(x,y,z)-R3, y, f_th(x,y,z))}
        max_gradient 3.3
        contained_by {sphere {0, 3} }
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
}
 
