#include "functions.inc"

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<-100,200,-100> colour rgb 1}

global_settings {assumed_gamma 1.0}

// ----------------------------------------
                           
#declare HF=true;                           
                           
                           

#declare P1=function{pattern{leopard turbulence 0.3 scale 0.05}}
#declare P2=function{pattern{crackle turbulence 0.3 scale 0.7}}

#declare P=function{P1(x,0,z)*0.3 +P2(x,0,z)}

#declare G=pigment{gradient y
         colour_map {[0.04 rgb <0.1,0.4,0.1>]
                     [0.10 rgb <0.5,0.4,0.3>]
                     [0.25 rgb 0.5]
                     [0.65 rgb 1.0]
                     }
         translate -0.02*y
         }
         
#declare Terrain =
#if (HF)
  height_field{function 300,300{P(x,0,y)}
    translate <-0.5,0,-0.5>
    scale <4,0.75,4>
    pigment{G}
  }
#else
  isosurface {
    function { y - P(x,0,1-z)}
    open
    max_gradient 7
    contained_by{box{<0,0,0>,<1,1,1>}}
    translate <-0.5,0,-0.5>
    scale <4,0.75,4>
    pigment {G}
  }
#end

object{Terrain}

#declare CameraPos = trace(Terrain,<0.6,100,-1.9>,-y);

camera {location CameraPos+0.05*y look_at <0, 0, 0>}
