#include "functions.inc"

camera { location  <0, 2,-3> look_at <0, 0.1, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<-100,200,-100> colour rgb 1}

// ----------------------------------------


#declare P1=function{pattern{leopard turbulence 0.3 scale 0.2/4}}

#declare P2=function{pattern{leopard turbulence 0.3 scale 0.5/4}}

#declare G=pigment{gradient y
         colour_map {[0.04 rgb <0.1,0.4,0.1>]
                     [0.10 rgb <0.5,0.4,0.3>]
                     [0.25 rgb 0.5]
                     [0.65 rgb 1.0]
                     }
         translate -0.05*y
         }
         

height_field{function 300,300{P1(x,y,z)*0.3+P2(x,y,z)}
  translate <-0.5,0,-0.5>
  scale <4,0.7,4>
  pigment{G}
}



box {<-2,-0.1,-2><2,0,2>
     pigment {rgb <0.3,0.4,0.6>}
     rotate x*5
    }